/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.commands;

import io.sealights.onpremise.agents.infra.git.api.FileDiffRanges;
import io.sealights.onpremise.agents.infra.git.cli.commands.GitDataDiscoveryCliCommand;
import io.sealights.onpremise.agents.infra.git.cli.rangesparser.GitDiffRangesParser;
import io.sealights.onpremise.agents.infra.git.cli.rangesparser.InputProvider;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.utils.GitCommandInternalTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import lombok.Generated;

public class GitDiffRangesCliCommand
extends GitDataDiscoveryCliCommand
implements InputProvider {
    private GitDiffRangesParser diffRangesParser = new GitDiffRangesParser(this.getGitWorkMonitor());
    private BufferedReader reader;
    List<FileDiffRanges> filesDiffRanges;

    public GitDiffRangesCliCommand(GitRepo gitRepo, GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData, GitWorkConfiguration configuration) {
        super(gitRepo, gitDiscoveryData, configuration);
    }

    @Override
    protected String getGitCliArgs() {
        return String.format("diff %s...HEAD --no-merges -M50 -U0 --diff-filter=ad", this.getReferenceId());
    }

    @Override
    protected void readCliOutput(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.filesDiffRanges = this.diffRangesParser.parse(this);
        this.updateDiscoveryData();
    }

    protected void updateDiscoveryData() {
        for (FileDiffRanges entry : this.filesDiffRanges) {
            this.getGitDiscoveryData().addFileDiffRanges(entry);
        }
    }

    @Override
    protected boolean handleOutputLine(String outputLine) {
        return true;
    }

    @Override
    public String readLine() {
        return this.reader.readLine();
    }

    @Override
    public void notifyRelevantLine(String line) {
        this.accumulateCliOutput(line);
    }

    @Override
    protected void reportResults() {
        if (this.getConfiguration().isDebugInfoEnabled()) {
            this.getGitWorkMonitor().addDebug(String.format("GIT-DIFF-2: cli output (%s lines): %s", this.getCliOutput().size(), this.toStringCliOuptput()));
        }
    }

    @Generated
    public GitDiffRangesParser getDiffRangesParser() {
        return this.diffRangesParser;
    }

    @Generated
    public BufferedReader getReader() {
        return this.reader;
    }

    @Generated
    public List<FileDiffRanges> getFilesDiffRanges() {
        return this.filesDiffRanges;
    }

    @Generated
    public void setDiffRangesParser(GitDiffRangesParser diffRangesParser) {
        this.diffRangesParser = diffRangesParser;
    }

    @Generated
    public void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    @Generated
    public void setFilesDiffRanges(List<FileDiffRanges> filesDiffRanges) {
        this.filesDiffRanges = filesDiffRanges;
    }

    @Override
    @Generated
    public String toString() {
        return "GitDiffRangesCliCommand(diffRangesParser=" + this.getDiffRangesParser() + ", reader=" + this.getReader() + ", filesDiffRanges=" + this.getFilesDiffRanges() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitDiffRangesCliCommand)) {
            return false;
        }
        GitDiffRangesCliCommand other = (GitDiffRangesCliCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitDiffRangesParser this$diffRangesParser = this.getDiffRangesParser();
        GitDiffRangesParser other$diffRangesParser = other.getDiffRangesParser();
        if (this$diffRangesParser == null ? other$diffRangesParser != null : !this$diffRangesParser.equals(other$diffRangesParser)) {
            return false;
        }
        BufferedReader this$reader = this.getReader();
        BufferedReader other$reader = other.getReader();
        if (this$reader == null ? other$reader != null : !this$reader.equals(other$reader)) {
            return false;
        }
        List<FileDiffRanges> this$filesDiffRanges = this.getFilesDiffRanges();
        List<FileDiffRanges> other$filesDiffRanges = other.getFilesDiffRanges();
        return !(this$filesDiffRanges == null ? other$filesDiffRanges != null : !((Object)this$filesDiffRanges).equals(other$filesDiffRanges));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitDiffRangesCliCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GitDiffRangesParser $diffRangesParser = this.getDiffRangesParser();
        result = result * 59 + ($diffRangesParser == null ? 43 : $diffRangesParser.hashCode());
        BufferedReader $reader = this.getReader();
        result = result * 59 + ($reader == null ? 43 : $reader.hashCode());
        List<FileDiffRanges> $filesDiffRanges = this.getFilesDiffRanges();
        result = result * 59 + ($filesDiffRanges == null ? 43 : ((Object)$filesDiffRanges).hashCode());
        return result;
    }
}

