/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.commands;

import io.sealights.onpremise.agents.infra.git.cli.commands.GitCliCommand;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.utils.GitCommandInternalTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import lombok.Generated;

public abstract class GitDataDiscoveryCliCommand
extends GitCliCommand<GitCommandInternalTypes.GitDiscoveryData> {
    private GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData;
    private GitWorkConfiguration configuration;

    public GitDataDiscoveryCliCommand(GitRepo gitRepo, GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData, GitWorkConfiguration configuration) {
        super(gitRepo);
        this.gitDiscoveryData = gitDiscoveryData;
        this.configuration = configuration;
    }

    @Override
    protected GitCommandInternalTypes.GitDiscoveryData collectData() {
        if (this.getReferenceId() != null) {
            this.runCli();
        }
        return this.gitDiscoveryData;
    }

    protected String getReferenceId() {
        return this.gitDiscoveryData.getReferenceId();
    }

    protected String toStringCliOuptput() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder(lineSeparator);
        for (String line : this.getCliOutput()) {
            builder.append(line).append(lineSeparator);
        }
        return builder.toString();
    }

    @Override
    protected boolean doAccumulateCliOutput() {
        return this.configuration.isDebugInfoEnabled();
    }

    @Generated
    public GitCommandInternalTypes.GitDiscoveryData getGitDiscoveryData() {
        return this.gitDiscoveryData;
    }

    @Generated
    public GitWorkConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setGitDiscoveryData(GitCommandInternalTypes.GitDiscoveryData gitDiscoveryData) {
        this.gitDiscoveryData = gitDiscoveryData;
    }

    @Generated
    public void setConfiguration(GitWorkConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    @Generated
    public String toString() {
        return "GitDataDiscoveryCliCommand(gitDiscoveryData=" + this.getGitDiscoveryData() + ", configuration=" + this.getConfiguration() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitDataDiscoveryCliCommand)) {
            return false;
        }
        GitDataDiscoveryCliCommand other = (GitDataDiscoveryCliCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitCommandInternalTypes.GitDiscoveryData this$gitDiscoveryData = this.getGitDiscoveryData();
        GitCommandInternalTypes.GitDiscoveryData other$gitDiscoveryData = other.getGitDiscoveryData();
        if (this$gitDiscoveryData == null ? other$gitDiscoveryData != null : !((Object)this$gitDiscoveryData).equals(other$gitDiscoveryData)) {
            return false;
        }
        GitWorkConfiguration this$configuration = this.getConfiguration();
        GitWorkConfiguration other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitDataDiscoveryCliCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        GitCommandInternalTypes.GitDiscoveryData $gitDiscoveryData = this.getGitDiscoveryData();
        result = result * 59 + ($gitDiscoveryData == null ? 43 : ((Object)$gitDiscoveryData).hashCode());
        GitWorkConfiguration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        return result;
    }
}

