/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.cli.commands;

import io.sealights.onpremise.agents.infra.env.OsDetector;
import io.sealights.onpremise.agents.infra.git.utils.GitCommand;
import io.sealights.onpremise.agents.infra.git.utils.GitRepo;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public abstract class GitCliCommand<T>
extends GitCommand<T> {
    private static String CLI_INFO_FMT = "executing cmd:'%s' from cwd:'%s'";
    private static char TAB_CHAR = (char)9;
    private static char SPACE_CHAR = (char)32;
    private List<String> cliOutput = new ArrayList<String>();

    public GitCliCommand(GitRepo gitRepo) {
        super(gitRepo);
    }

    protected boolean runCli() {
        String cmd = this.buildCliCmd();
        this.getGitWorkMonitor().addInfo(String.format(CLI_INFO_FMT, cmd, this.getGitRepo().getRepoPath()), true);
        ArrayList<String> commandArgs = new ArrayList<String>();
        if (OsDetector.isWindows()) {
            commandArgs.add("cmd.exe");
            commandArgs.add("/C");
        }
        List<String> args = Arrays.asList(cmd.split(" "));
        commandArgs.addAll(args);
        try {
            ProcessBuilder pb = new ProcessBuilder(commandArgs);
            pb.directory(new File(this.getGitRepo().getRepoPath()));
            Process process = pb.start();
            if (!this.handleErrorsOutput(process)) {
                this.readCliOutput(process.getInputStream());
            }
            this.reportResults();
            return true;
        }
        catch (Throwable e) {
            this.handleRunCliException(cmd, e);
            return false;
        }
    }

    protected void readCliOutput(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        while (this.readGitOutputLine(reader)) {
        }
    }

    protected boolean readGitOutputLine(BufferedReader reader) {
        try {
            String line = reader.readLine();
            if (line == null) {
                return false;
            }
            if (this.handleOutputLine(line)) {
                this.accumulateCliOutput(line);
            }
        }
        catch (Throwable e) {
            this.getGitWorkMonitor().addException("failed to read a line from git cli output, line was skipped", this.getClass(), e);
        }
        return true;
    }

    protected void accumulateCliOutput(String line) {
        if (!line.isEmpty() && this.doAccumulateCliOutput()) {
            this.cliOutput.add(line.replace(TAB_CHAR, SPACE_CHAR));
        }
    }

    protected boolean handleErrorsOutput(Process process) throws Exception {
        if (process.getErrorStream().available() > 0) {
            StringBuilder errors = new StringBuilder();
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (this.readGitOutputErrorLine(errorReader, errors)) {
            }
            if (!errors.toString().isEmpty()) {
                this.getGitWorkMonitor().addError("cli errors:" + errors.toString());
                return true;
            }
        }
        return false;
    }

    protected boolean readGitOutputErrorLine(BufferedReader reader, StringBuilder errors) {
        try {
            String line = reader.readLine();
            if (line != null) {
                errors.append(line).append("\n");
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            this.getGitWorkMonitor().addException("failed to read a line from git cli error output", this.getClass(), e);
            return true;
        }
    }

    protected void handleRunCliException(String cmd, Throwable e) {
        this.getGitWorkMonitor().addException(String.format("failed execute '%s'", cmd), this.getClass(), e);
    }

    protected void reportResults() {
    }

    protected String buildCliCmd() {
        return this.getGitRepo().getGitExecPath() + " " + this.getGitCliArgs();
    }

    protected abstract String getGitCliArgs();

    protected abstract boolean handleOutputLine(String var1);

    protected abstract boolean doAccumulateCliOutput();

    @Generated
    public List<String> getCliOutput() {
        return this.cliOutput;
    }

    @Generated
    public void setCliOutput(List<String> cliOutput) {
        this.cliOutput = cliOutput;
    }

    @Override
    @Generated
    public String toString() {
        return "GitCliCommand(cliOutput=" + this.getCliOutput() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitCliCommand)) {
            return false;
        }
        GitCliCommand other = (GitCliCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$cliOutput = this.getCliOutput();
        List<String> other$cliOutput = other.getCliOutput();
        return !(this$cliOutput == null ? other$cliOutput != null : !((Object)this$cliOutput).equals(other$cliOutput));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GitCliCommand;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $cliOutput = this.getCliOutput();
        result = result * 59 + ($cliOutput == null ? 43 : ((Object)$cliOutput).hashCode());
        return result;
    }
}

