/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.sealights.onpremise.agents.infra.git.api.GitDataPrinter;
import io.sealights.onpremise.agents.infra.git.api.GitDiffsTypes;
import io.sealights.onpremise.agents.infra.git.api.GitFilesTypes;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class GitServiceApiTypes {

    public static class ErrorInfo {
        private int code;
        private String message;

        public ErrorInfo(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public String toString() {
            if (StringUtils.isNotEmpty(this.message)) {
                return String.format("code=%s, message='%s'", this.code, this.message);
            }
            return String.format("code=%s (no message)", this.code);
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public void setCode(int code) {
            this.code = code;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorInfo)) {
                return false;
            }
            ErrorInfo other = (ErrorInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            return !(this$message == null ? other$message != null : !this$message.equals(other$message));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ErrorInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            return result;
        }

        @Generated
        public ErrorInfo() {
        }
    }

    public static class SimpleResponse {
        private ErrorInfo error;

        public SimpleResponse(ErrorInfo error) {
            this.error = error;
        }

        public String toString() {
            return String.format("error:{%s}", this.error);
        }

        @Generated
        public ErrorInfo getError() {
            return this.error;
        }

        @Generated
        public void setError(ErrorInfo error) {
            this.error = error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleResponse)) {
                return false;
            }
            SimpleResponse other = (SimpleResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ErrorInfo this$error = this.getError();
            ErrorInfo other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SimpleResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ErrorInfo $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        @Generated
        public SimpleResponse() {
        }
    }

    public static class DataResponse<T>
    extends SimpleResponse {
        private T data;

        public String toStringData() {
            return String.format("data=%s, %s", this.data, super.toString());
        }

        @Generated
        public DataResponse() {
        }

        @Generated
        public T getData() {
            return this.data;
        }

        @Generated
        public void setData(T data2) {
            this.data = data2;
        }

        @Override
        @Generated
        public String toString() {
            return "GitServiceApiTypes.DataResponse(data=" + this.getData() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DataResponse)) {
                return false;
            }
            DataResponse other = (DataResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            T this$data = this.getData();
            T other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DataResponse;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            T $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }
    }

    public static class GitData {
        private GitFilesTypes.ScmData scmData;
        @JsonProperty(value="commit")
        private String headCommit;
        private List<GitFilesTypes.GitCommitData> commitDetails = new ArrayList<GitFilesTypes.GitCommitData>();
        private List<GitFilesTypes.ContributorData> contributors = new ArrayList<GitFilesTypes.ContributorData>();
        private GitDiffsTypes.BuildDiff buildDiff = new GitDiffsTypes.BuildDiff();

        public int addContributor(GitFilesTypes.ContributorData entry) {
            int index = this.contributors.indexOf(entry);
            if (index == -1) {
                index = this.contributors.size();
                entry.setIndex(index);
                this.contributors.add(entry);
            }
            return index;
        }

        public void addCommitData(GitFilesTypes.GitCommitData commitData) {
            if (this.commitDetails.isEmpty()) {
                this.headCommit = commitData.getCommit();
            }
            commitData.setIndex(this.commitDetails.size());
            this.commitDetails.add(commitData);
        }

        public String toString() {
            return GitDataPrinter.GIT_DATA_SHORT_PRINTER.toString(this);
        }

        @Generated
        public GitFilesTypes.ScmData getScmData() {
            return this.scmData;
        }

        @Generated
        public String getHeadCommit() {
            return this.headCommit;
        }

        @Generated
        public List<GitFilesTypes.GitCommitData> getCommitDetails() {
            return this.commitDetails;
        }

        @Generated
        public List<GitFilesTypes.ContributorData> getContributors() {
            return this.contributors;
        }

        @Generated
        public GitDiffsTypes.BuildDiff getBuildDiff() {
            return this.buildDiff;
        }

        @Generated
        public void setScmData(GitFilesTypes.ScmData scmData) {
            this.scmData = scmData;
        }

        @JsonProperty(value="commit")
        @Generated
        public void setHeadCommit(String headCommit) {
            this.headCommit = headCommit;
        }

        @Generated
        public void setCommitDetails(List<GitFilesTypes.GitCommitData> commitDetails) {
            this.commitDetails = commitDetails;
        }

        @Generated
        public void setContributors(List<GitFilesTypes.ContributorData> contributors) {
            this.contributors = contributors;
        }

        @Generated
        public void setBuildDiff(GitDiffsTypes.BuildDiff buildDiff) {
            this.buildDiff = buildDiff;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitData)) {
                return false;
            }
            GitData other = (GitData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GitFilesTypes.ScmData this$scmData = this.getScmData();
            GitFilesTypes.ScmData other$scmData = other.getScmData();
            if (this$scmData == null ? other$scmData != null : !((Object)this$scmData).equals(other$scmData)) {
                return false;
            }
            String this$headCommit = this.getHeadCommit();
            String other$headCommit = other.getHeadCommit();
            if (this$headCommit == null ? other$headCommit != null : !this$headCommit.equals(other$headCommit)) {
                return false;
            }
            List<GitFilesTypes.GitCommitData> this$commitDetails = this.getCommitDetails();
            List<GitFilesTypes.GitCommitData> other$commitDetails = other.getCommitDetails();
            if (this$commitDetails == null ? other$commitDetails != null : !((Object)this$commitDetails).equals(other$commitDetails)) {
                return false;
            }
            List<GitFilesTypes.ContributorData> this$contributors = this.getContributors();
            List<GitFilesTypes.ContributorData> other$contributors = other.getContributors();
            if (this$contributors == null ? other$contributors != null : !((Object)this$contributors).equals(other$contributors)) {
                return false;
            }
            GitDiffsTypes.BuildDiff this$buildDiff = this.getBuildDiff();
            GitDiffsTypes.BuildDiff other$buildDiff = other.getBuildDiff();
            return !(this$buildDiff == null ? other$buildDiff != null : !((Object)this$buildDiff).equals(other$buildDiff));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GitData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GitFilesTypes.ScmData $scmData = this.getScmData();
            result = result * 59 + ($scmData == null ? 43 : ((Object)$scmData).hashCode());
            String $headCommit = this.getHeadCommit();
            result = result * 59 + ($headCommit == null ? 43 : $headCommit.hashCode());
            List<GitFilesTypes.GitCommitData> $commitDetails = this.getCommitDetails();
            result = result * 59 + ($commitDetails == null ? 43 : ((Object)$commitDetails).hashCode());
            List<GitFilesTypes.ContributorData> $contributors = this.getContributors();
            result = result * 59 + ($contributors == null ? 43 : ((Object)$contributors).hashCode());
            GitDiffsTypes.BuildDiff $buildDiff = this.getBuildDiff();
            result = result * 59 + ($buildDiff == null ? 43 : ((Object)$buildDiff).hashCode());
            return result;
        }

        @Generated
        public GitData() {
        }
    }

    public static class GetRefCommitResponse
    extends DataResponse<GitFilesTypes.RefCommitData> {
        public GetRefCommitResponse(GitFilesTypes.RefCommitData data2) {
            this.setData(data2);
        }

        @Override
        public String toString() {
            return this.toStringData();
        }

        @Generated
        public GetRefCommitResponse() {
        }
    }

    public static class GitDataSumbitted {
        private boolean submitted;

        public GitDataSumbitted(boolean submitted) {
            this.submitted = submitted;
        }

        @Generated
        public boolean isSubmitted() {
            return this.submitted;
        }

        @Generated
        public void setSubmitted(boolean submitted) {
            this.submitted = submitted;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GitDataSumbitted)) {
                return false;
            }
            GitDataSumbitted other = (GitDataSumbitted)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isSubmitted() == other.isSubmitted();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GitDataSumbitted;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSubmitted() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "GitServiceApiTypes.GitDataSumbitted(submitted=" + this.isSubmitted() + ")";
        }

        @Generated
        public GitDataSumbitted() {
        }
    }

    public static class GetGitDataSubmittedResponse
    extends DataResponse<GitDataSumbitted> {
        @Override
        public String toString() {
            return this.toStringData();
        }
    }
}

