/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.api;

import io.sealights.onpremise.agents.infra.git.configuration.ScmSettings;
import io.sealights.onpremise.agents.infra.git.utils.GitUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public class GitFilesTypes {
    public static ScmData NONE_SCM = new ScmData();

    public static class RefCommitData {
        private String commit;
        boolean sendFullData = false;

        public RefCommitData(String commit, boolean sendFullData) {
            this.commit = commit;
            this.sendFullData = sendFullData;
        }

        public String toString() {
            return String.format("ref-commit=%s, sendFullData=%s", GitUtils.shortId(this.commit), this.sendFullData);
        }

        @Generated
        public String getCommit() {
            return this.commit;
        }

        @Generated
        public boolean isSendFullData() {
            return this.sendFullData;
        }

        @Generated
        public void setCommit(String commit) {
            this.commit = commit;
        }

        @Generated
        public void setSendFullData(boolean sendFullData) {
            this.sendFullData = sendFullData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefCommitData)) {
                return false;
            }
            RefCommitData other = (RefCommitData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSendFullData() != other.isSendFullData()) {
                return false;
            }
            String this$commit = this.getCommit();
            String other$commit = other.getCommit();
            return !(this$commit == null ? other$commit != null : !this$commit.equals(other$commit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RefCommitData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSendFullData() ? 79 : 97);
            String $commit = this.getCommit();
            result = result * 59 + ($commit == null ? 43 : $commit.hashCode());
            return result;
        }

        @Generated
        public RefCommitData() {
        }
    }

    public static class ScmData {
        private String repositoryUrl = null;
        private ScmType type = ScmType.none;
        private String provider;
        private String version;
        private String baseUrl;

        public ScmData(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
            this.type = ScmType.git;
        }

        public ScmData(String repositoryUrl, ScmSettings settings) {
            this(repositoryUrl);
            this.applyScmSettings(settings);
        }

        private void applyScmSettings(ScmSettings settings) {
            this.provider = settings.getGitProvider();
            this.version = settings.getVersion();
            this.baseUrl = settings.getBaseUrl();
        }

        public String toString() {
            return String.format("repositoryUrl=%s, type=%s, provider=%s, version=%s, baseUrl=%s", new Object[]{this.repositoryUrl, this.type, this.provider, this.version, this.baseUrl});
        }

        @Generated
        public String getRepositoryUrl() {
            return this.repositoryUrl;
        }

        @Generated
        public ScmType getType() {
            return this.type;
        }

        @Generated
        public String getProvider() {
            return this.provider;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getBaseUrl() {
            return this.baseUrl;
        }

        @Generated
        public void setRepositoryUrl(String repositoryUrl) {
            this.repositoryUrl = repositoryUrl;
        }

        @Generated
        public void setType(ScmType type) {
            this.type = type;
        }

        @Generated
        public void setProvider(String provider) {
            this.provider = provider;
        }

        @Generated
        public void setVersion(String version) {
            this.version = version;
        }

        @Generated
        public void setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScmData)) {
                return false;
            }
            ScmData other = (ScmData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$repositoryUrl = this.getRepositoryUrl();
            String other$repositoryUrl = other.getRepositoryUrl();
            if (this$repositoryUrl == null ? other$repositoryUrl != null : !this$repositoryUrl.equals(other$repositoryUrl)) {
                return false;
            }
            ScmType this$type = this.getType();
            ScmType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            String this$provider = this.getProvider();
            String other$provider = other.getProvider();
            if (this$provider == null ? other$provider != null : !this$provider.equals(other$provider)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$baseUrl = this.getBaseUrl();
            String other$baseUrl = other.getBaseUrl();
            return !(this$baseUrl == null ? other$baseUrl != null : !this$baseUrl.equals(other$baseUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ScmData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $repositoryUrl = this.getRepositoryUrl();
            result = result * 59 + ($repositoryUrl == null ? 43 : $repositoryUrl.hashCode());
            ScmType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            String $provider = this.getProvider();
            result = result * 59 + ($provider == null ? 43 : $provider.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $baseUrl = this.getBaseUrl();
            result = result * 59 + ($baseUrl == null ? 43 : $baseUrl.hashCode());
            return result;
        }

        @Generated
        public ScmData() {
        }
    }

    public static enum ScmType {
        git,
        none;


        public static String valuesToString() {
            return Arrays.toString((Object[])ScmType.values());
        }
    }

    public static class TreeFileData {
        private String hash;
        private List<Integer> commitIndices = new ArrayList<Integer>();

        public TreeFileData(String hash) {
            this.hash = hash;
        }

        public void addCommitIndex(int index) {
            this.commitIndices.add(index);
        }

        public String toString() {
            return String.format("hash=%s, commits:[%s]", this.hash, this.toString(this.commitIndices));
        }

        private String toString(List<Integer> commits) {
            StringBuilder buf = new StringBuilder();
            int loopCtr = 0;
            for (int entry : commits) {
                if (++loopCtr > 1) {
                    buf.append(", ");
                }
                buf.append(entry);
            }
            return buf.toString();
        }

        @Generated
        public String getHash() {
            return this.hash;
        }

        @Generated
        public List<Integer> getCommitIndices() {
            return this.commitIndices;
        }

        @Generated
        public void setHash(String hash) {
            this.hash = hash;
        }

        @Generated
        public void setCommitIndices(List<Integer> commitIndices) {
            this.commitIndices = commitIndices;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TreeFileData)) {
                return false;
            }
            TreeFileData other = (TreeFileData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$hash = this.getHash();
            String other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
                return false;
            }
            List<Integer> this$commitIndices = this.getCommitIndices();
            List<Integer> other$commitIndices = other.getCommitIndices();
            return !(this$commitIndices == null ? other$commitIndices != null : !((Object)this$commitIndices).equals(other$commitIndices));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TreeFileData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $hash = this.getHash();
            result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
            List<Integer> $commitIndices = this.getCommitIndices();
            result = result * 59 + ($commitIndices == null ? 43 : ((Object)$commitIndices).hashCode());
            return result;
        }

        @Generated
        public TreeFileData() {
        }
    }

    public static class ContributorData {
        private int index;
        private String name;
        private String email;

        public ContributorData(String name, String email) {
            this.name = name;
            this.email = email;
        }

        public int hashCode() {
            return Objects.hash(this.email, this.name);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContributorData other = (ContributorData)obj;
            return Objects.equals(this.email, other.email) && Objects.equals(this.name, other.name);
        }

        public String toString() {
            return String.format("index=%s, name=%s, email=%s", this.index, this.name, this.email);
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public void setIndex(int index) {
            this.index = index;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public ContributorData() {
        }
    }

    public static class GitCommitData {
        private int index;
        private String commit;
        private long authorDate;
        private long committerDate;
        private String title;
        private int contributorIndex;

        public GitCommitData(String commit, long authorDate, long committerDate, String title, int contributorIndex) {
            this.commit = commit;
            this.authorDate = authorDate;
            this.committerDate = committerDate;
            this.title = title;
            this.contributorIndex = contributorIndex;
        }

        public String toString() {
            return String.format("index=%s, commit=%s, authorDate=%s, committerDate=%s, title=%s, contributorIndex=%s", this.index, this.commit, this.authorDate, this.committerDate, this.title, this.contributorIndex);
        }

        public int hashCode() {
            return Objects.hash(this.authorDate, this.commit, this.committerDate, this.contributorIndex, this.title);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GitCommitData other = (GitCommitData)obj;
            return this.authorDate == other.authorDate && Objects.equals(this.commit, other.commit) && this.committerDate == other.committerDate && this.contributorIndex == other.contributorIndex && Objects.equals(this.title, other.title);
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getCommit() {
            return this.commit;
        }

        @Generated
        public long getAuthorDate() {
            return this.authorDate;
        }

        @Generated
        public long getCommitterDate() {
            return this.committerDate;
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public int getContributorIndex() {
            return this.contributorIndex;
        }

        @Generated
        public void setIndex(int index) {
            this.index = index;
        }

        @Generated
        public void setCommit(String commit) {
            this.commit = commit;
        }

        @Generated
        public void setAuthorDate(long authorDate) {
            this.authorDate = authorDate;
        }

        @Generated
        public void setCommitterDate(long committerDate) {
            this.committerDate = committerDate;
        }

        @Generated
        public void setTitle(String title) {
            this.title = title;
        }

        @Generated
        public void setContributorIndex(int contributorIndex) {
            this.contributorIndex = contributorIndex;
        }

        @Generated
        public GitCommitData() {
        }
    }

    public static enum GitDiffStatus {
        added,
        deleted,
        modified,
        renamed,
        renamedAndModified;

    }
}

