/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.api;

import io.sealights.onpremise.agents.infra.git.api.FileDiffRanges;
import io.sealights.onpremise.agents.infra.git.api.GitDataPrinter;
import io.sealights.onpremise.agents.infra.git.utils.FileDiffsModifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;

public class GitDiffsTypes {

    public static class BuildDiff {
        private String refCommit;
        private boolean diffDone = false;
        private List<ModuleFiles> modules = new ArrayList<ModuleFiles>();

        public String toString() {
            return GitDataPrinter.GIT_DATA_SHORT_PRINTER.toString(this);
        }

        public int countFiles() {
            int size = 0;
            for (ModuleFiles moduleFiles : this.modules) {
                size += moduleFiles.getFiles().size();
            }
            return size;
        }

        @Generated
        public String getRefCommit() {
            return this.refCommit;
        }

        @Generated
        public boolean isDiffDone() {
            return this.diffDone;
        }

        @Generated
        public List<ModuleFiles> getModules() {
            return this.modules;
        }

        @Generated
        public void setRefCommit(String refCommit) {
            this.refCommit = refCommit;
        }

        @Generated
        public void setDiffDone(boolean diffDone) {
            this.diffDone = diffDone;
        }

        @Generated
        public void setModules(List<ModuleFiles> modules) {
            this.modules = modules;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BuildDiff)) {
                return false;
            }
            BuildDiff other = (BuildDiff)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDiffDone() != other.isDiffDone()) {
                return false;
            }
            String this$refCommit = this.getRefCommit();
            String other$refCommit = other.getRefCommit();
            if (this$refCommit == null ? other$refCommit != null : !this$refCommit.equals(other$refCommit)) {
                return false;
            }
            List<ModuleFiles> this$modules = this.getModules();
            List<ModuleFiles> other$modules = other.getModules();
            return !(this$modules == null ? other$modules != null : !((Object)this$modules).equals(other$modules));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BuildDiff;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDiffDone() ? 79 : 97);
            String $refCommit = this.getRefCommit();
            result = result * 59 + ($refCommit == null ? 43 : $refCommit.hashCode());
            List<ModuleFiles> $modules = this.getModules();
            result = result * 59 + ($modules == null ? 43 : ((Object)$modules).hashCode());
            return result;
        }

        @Generated
        public BuildDiff() {
        }
    }

    public static class FileDiffsMap
    extends HashMap<String, FileDiffs> {
        public void putAddedFile(String path) {
            this.put(path, new FileDiffs(GitDiffStatus.added));
        }

        public <T> boolean updateFile(String filePath, T data2, FileDiffsModifier<T> modifier) {
            FileDiffs fileDiffs = (FileDiffs)this.get(filePath);
            if (fileDiffs != null) {
                return modifier.modify(fileDiffs, data2);
            }
            return false;
        }

        @Override
        public String toString() {
            return GitDataPrinter.MODULE_FILES_LIST_PRINTER.toString(this);
        }
    }

    public static class ModuleFiles {
        private String moduleDirectory;
        private FileDiffsMap files;

        public ModuleFiles(String moduleName, FileDiffsMap files) {
            this.moduleDirectory = moduleName;
            this.files = files;
        }

        public String toString() {
            return GitDataPrinter.MODULE_FILES_LIST_PRINTER.toString(this);
        }

        @Generated
        public String getModuleDirectory() {
            return this.moduleDirectory;
        }

        @Generated
        public FileDiffsMap getFiles() {
            return this.files;
        }

        @Generated
        public void setModuleDirectory(String moduleDirectory) {
            this.moduleDirectory = moduleDirectory;
        }

        @Generated
        public void setFiles(FileDiffsMap files) {
            this.files = files;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleFiles)) {
                return false;
            }
            ModuleFiles other = (ModuleFiles)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$moduleDirectory = this.getModuleDirectory();
            String other$moduleDirectory = other.getModuleDirectory();
            if (this$moduleDirectory == null ? other$moduleDirectory != null : !this$moduleDirectory.equals(other$moduleDirectory)) {
                return false;
            }
            FileDiffsMap this$files = this.getFiles();
            FileDiffsMap other$files = other.getFiles();
            return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ModuleFiles;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $moduleDirectory = this.getModuleDirectory();
            result = result * 59 + ($moduleDirectory == null ? 43 : $moduleDirectory.hashCode());
            FileDiffsMap $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            return result;
        }

        @Generated
        public ModuleFiles() {
        }
    }

    public static class FileDiffs {
        private GitDiffStatus status;
        private String oldPath;
        private List<Integer> commitIndices = new ArrayList<Integer>();
        private List<FileDiffRanges.DiffRanges> touchedLines = new ArrayList<FileDiffRanges.DiffRanges>();

        public FileDiffs(GitDiffStatus status) {
            this(status, null);
        }

        public FileDiffs(GitDiffStatus status, String oldPath) {
            this.status = status;
            this.oldPath = oldPath;
        }

        public void addCommitIndex(int index) {
            this.commitIndices.add(index);
        }

        public String toString() {
            return String.format("%s, commits:[%s], touched:[%s]", new Object[]{this.status, this.toString(this.commitIndices), this.toString(this.touchedLines)});
        }

        private <T> String toString(List<T> values2) {
            StringBuilder buf = new StringBuilder();
            int loopCtr = 0;
            for (T entry : values2) {
                if (++loopCtr > 1) {
                    buf.append(", ");
                }
                buf.append(entry);
            }
            return buf.toString();
        }

        @Generated
        public GitDiffStatus getStatus() {
            return this.status;
        }

        @Generated
        public String getOldPath() {
            return this.oldPath;
        }

        @Generated
        public List<Integer> getCommitIndices() {
            return this.commitIndices;
        }

        @Generated
        public List<FileDiffRanges.DiffRanges> getTouchedLines() {
            return this.touchedLines;
        }

        @Generated
        public void setStatus(GitDiffStatus status) {
            this.status = status;
        }

        @Generated
        public void setOldPath(String oldPath) {
            this.oldPath = oldPath;
        }

        @Generated
        public void setCommitIndices(List<Integer> commitIndices) {
            this.commitIndices = commitIndices;
        }

        @Generated
        public void setTouchedLines(List<FileDiffRanges.DiffRanges> touchedLines) {
            this.touchedLines = touchedLines;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileDiffs)) {
                return false;
            }
            FileDiffs other = (FileDiffs)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GitDiffStatus this$status = this.getStatus();
            GitDiffStatus other$status = other.getStatus();
            if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
                return false;
            }
            String this$oldPath = this.getOldPath();
            String other$oldPath = other.getOldPath();
            if (this$oldPath == null ? other$oldPath != null : !this$oldPath.equals(other$oldPath)) {
                return false;
            }
            List<Integer> this$commitIndices = this.getCommitIndices();
            List<Integer> other$commitIndices = other.getCommitIndices();
            if (this$commitIndices == null ? other$commitIndices != null : !((Object)this$commitIndices).equals(other$commitIndices)) {
                return false;
            }
            List<FileDiffRanges.DiffRanges> this$touchedLines = this.getTouchedLines();
            List<FileDiffRanges.DiffRanges> other$touchedLines = other.getTouchedLines();
            return !(this$touchedLines == null ? other$touchedLines != null : !((Object)this$touchedLines).equals(other$touchedLines));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileDiffs;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GitDiffStatus $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
            String $oldPath = this.getOldPath();
            result = result * 59 + ($oldPath == null ? 43 : $oldPath.hashCode());
            List<Integer> $commitIndices = this.getCommitIndices();
            result = result * 59 + ($commitIndices == null ? 43 : ((Object)$commitIndices).hashCode());
            List<FileDiffRanges.DiffRanges> $touchedLines = this.getTouchedLines();
            result = result * 59 + ($touchedLines == null ? 43 : ((Object)$touchedLines).hashCode());
            return result;
        }

        @Generated
        public FileDiffs() {
        }
    }

    public static enum GitDiffStatus {
        added,
        deleted,
        modified,
        renamed,
        renamedAndModified;

    }
}

