/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.git.api;

import io.sealights.onpremise.agents.infra.git.api.GitDiffsTypes;
import io.sealights.onpremise.agents.infra.git.api.GitServiceApiTypes;
import io.sealights.onpremise.agents.infra.git.utils.GitUtils;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import io.sealights.onpremise.agents.infra.logging.Printer;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import java.util.List;
import java.util.Map;

public class GitDataPrinter {
    public static final GitDataShortPrinter GIT_DATA_SHORT_PRINTER = new GitDataShortPrinter();
    public static final GitDataFullPrinter GIT_DATA_FULL_PRINTER = new GitDataFullPrinter();
    public static final ModuleFilesListPrinter MODULE_FILES_LIST_PRINTER = new ModuleFilesListPrinter();

    public static String toString(Level logLevel, GitServiceApiTypes.GitData gitData) {
        StringBuilder buf = new StringBuilder();
        buf.append(ToStringFormatter.toString(GIT_DATA_SHORT_PRINTER, gitData));
        if (logLevel == Level.DEBUG) {
            buf.append(LogLevelToStringFormatter.toString(logLevel, GIT_DATA_FULL_PRINTER, gitData));
        }
        return buf.toString();
    }

    public static class ModuleFilesListPrinter
    implements Printer<List<GitDiffsTypes.ModuleFiles>> {
        @Override
        public String toString(List<GitDiffsTypes.ModuleFiles> value) {
            StringBuilder buf = new StringBuilder();
            if (value.isEmpty()) {
                buf.append("empty");
            } else {
                for (GitDiffsTypes.ModuleFiles module : value) {
                    buf.append(this.toString(module));
                }
            }
            return buf.toString();
        }

        @Override
        public String toString(GitDiffsTypes.ModuleFiles value) {
            return String.format("module '%s' - files%s", value.getModuleDirectory(), this.toString(value.getFiles()));
        }

        @Override
        public String toString(GitDiffsTypes.FileDiffsMap value) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("(%s):%n", value.size()));
            int ctr = 0;
            for (Map.Entry entry : value.entrySet()) {
                buf.append(String.format("[%-5d] '%s', %s", ++ctr, entry.getKey(), entry.getValue()));
                if (ctr >= value.size()) continue;
                buf.append("\n");
            }
            return buf.toString();
        }
    }

    public static class GitDataFullPrinter
    implements Printer<GitServiceApiTypes.GitData> {
        @Override
        public String toString(GitServiceApiTypes.GitData value) {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%ndetails: %s", ToStringFormatter.toString(MODULE_FILES_LIST_PRINTER, value.getBuildDiff().getModules())));
            buf.append(String.format("%ncommitLogData:%s", ToStringFormatter.toString(value.getCommitDetails())));
            buf.append(String.format("%ncontributors:%s", ToStringFormatter.toString(value.getContributors())));
            return buf.toString();
        }
    }

    public static class GitDataShortPrinter
    implements Printer<GitServiceApiTypes.GitData> {
        @Override
        public String toString(GitServiceApiTypes.GitData value) {
            return String.format("%s, %nheadCommit=%s, commits size=%s, contributors size=%s, %s", value.getScmData(), GitUtils.shortId(value.getHeadCommit()), value.getCommitDetails().size(), value.getContributors().size(), this.toString(value.getBuildDiff()));
        }

        @Override
        public String toString(GitDiffsTypes.BuildDiff value) {
            return String.format("refCommit=%s, diffDone=%s, %s", value.getRefCommit(), value.isDiffDone(), this.toStringModulesShort(value.getModules()));
        }

        public String toStringModulesShort(List<GitDiffsTypes.ModuleFiles> value) {
            StringBuilder buf = new StringBuilder();
            for (GitDiffsTypes.ModuleFiles entry : value) {
                buf.append(String.format("files size=%s, module '%s'", entry.getFiles().size(), entry.getModuleDirectory()));
            }
            return buf.toString();
        }
    }
}

