/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.filters;

import io.sealights.onpremise.agents.infra.filters.WildcardPattern;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class IncludeExcludeFilter {
    WildcardPattern include = null;
    WildcardPattern exclude = null;

    public IncludeExcludeFilter(String include, String exclude) {
        if (!StringUtils.isNullOrEmpty(include)) {
            this.include = new WildcardPattern(include);
        }
        if (!StringUtils.isNullOrEmpty(exclude)) {
            this.exclude = new WildcardPattern(exclude);
        }
    }

    public boolean filter(String value) {
        return this.filter(value, true);
    }

    public boolean filter(String value, boolean isPackage) {
        if (StringUtils.isNullOrEmpty(value)) {
            return false;
        }
        if (isPackage) {
            value = value.replace('/', '.');
        }
        if (this.isExcluded(value)) {
            return false;
        }
        return this.isIncluded(value);
    }

    private boolean isIncluded(String value) {
        if (this.include != null) {
            return this.include.matches(value);
        }
        return true;
    }

    private boolean isExcluded(String value) {
        if (this.exclude != null) {
            return this.exclude.matches(value);
        }
        return false;
    }

    public String toString() {
        String i = "<include is null>";
        if (this.include != null) {
            i = this.include.getInitialExpression();
        }
        String e = "<exclude is null>";
        if (this.exclude != null) {
            e = this.exclude.getInitialExpression();
        }
        return "IncludeExcludeFilter{include=" + i + ", exclude=" + e + '}';
    }
}

