/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.environment;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.sealights.onpremise.agents.infra.env.JvmEnvInfoCollector;
import io.sealights.onpremise.agents.infra.environment.BaseEnvironmentInfo;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DefaultEnvironmentInfo
extends BaseEnvironmentInfo {
    private static final String DEVELOPMENT_VERSION = "4.0.0-SNAPSHOT";

    public String getAgentType() {
        return "sealights agent";
    }

    public static String getAgentVersion() {
        String packageVersion = DefaultEnvironmentInfo.class.getPackage().getImplementationVersion();
        if (packageVersion == null) {
            packageVersion = DEVELOPMENT_VERSION;
        }
        return packageVersion;
    }

    public String getJvmName() {
        return JvmEnvInfoCollector.getJvmName();
    }

    public String getJavaVersion() {
        return JvmEnvInfoCollector.getJavaVersion();
    }

    public String getJavaVendor() {
        return JvmEnvInfoCollector.getJavaVendor();
    }

    public String getOs() {
        return JvmEnvInfoCollector.getOs();
    }

    public String getOsVersion() {
        return JvmEnvInfoCollector.getOsVersion();
    }

    public String getArch() {
        return JvmEnvInfoCollector.getArch();
    }

    public List<String> getIpAddresses() {
        return JvmEnvInfoCollector.getIpAddresses();
    }

    public String toString() {
        return String.format("{agentId=%s, agentType=%s, processId=%s...}", this.getAgentId(), this.getAgentType(), this.getProcessId());
    }
}

