/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.env;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class LocalNetworkInterfaceInfo {
    private List<String> ipAddresses;

    public static List<String> get() {
        return SingletonHolder.getInstance().ipAddresses;
    }

    private LocalNetworkInterfaceInfo() {
        this.resolveProcessId();
    }

    private void resolveProcessId() {
        this.ipAddresses = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface nic = nics.nextElement();
                Enumeration<InetAddress> inetAddresses = nic.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress i = inetAddresses.nextElement();
                    this.ipAddresses.add(i.getHostAddress());
                }
            }
        }
        catch (SocketException e) {
            new RuntimeException(e);
        }
    }

    private static class SingletonHolder {
        static final LocalNetworkInterfaceInfo INSTANCE = new LocalNetworkInterfaceInfo();

        private SingletonHolder() {
        }

        static LocalNetworkInterfaceInfo getInstance() {
            return INSTANCE;
        }
    }
}

