/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.env;

import java.net.InetAddress;

public final class LocalHostInfo {
    public static final String UNKNOWN_HOST = "unknown-host";
    private String hostName;

    public static String get() {
        return SingletonHolder.getInstance().hostName;
    }

    private LocalHostInfo() {
        this.resolveHostName();
    }

    private void resolveHostName() {
        try {
            this.hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            this.hostName = UNKNOWN_HOST;
        }
    }

    private static class SingletonHolder {
        static final LocalHostInfo INSTANCE = new LocalHostInfo();

        private SingletonHolder() {
        }

        static LocalHostInfo getInstance() {
            return INSTANCE;
        }
    }
}

