/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.env;

import io.sealights.onpremise.agents.infra.env.JvmProcessIdInfo;
import io.sealights.onpremise.agents.infra.env.LocalHostInfo;
import io.sealights.onpremise.agents.infra.env.LocalNetworkInterfaceInfo;
import java.util.List;

public class JvmEnvInfoCollector {
    public static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    public static final String JAVA_7_VERSION = "1.7";
    private static final String JAVA_VERSION_PREFIX_BEFORE_9 = "1.";

    public static boolean isPreJava9() {
        String javaVersion = JvmEnvInfoCollector.getJavaVersion();
        return javaVersion.startsWith(JAVA_VERSION_PREFIX_BEFORE_9);
    }

    public static boolean isJava7() {
        String javaVersion = System.getProperty(JAVA_SPECIFICATION_VERSION);
        return javaVersion.startsWith(JAVA_7_VERSION);
    }

    public static String getJvmName() {
        return System.getProperty("java.vm.name");
    }

    public static String getMachineName() {
        return LocalHostInfo.get();
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getJavaVendor() {
        return System.getProperty("java.vendor");
    }

    public static String getOs() {
        return System.getProperty("os.name");
    }

    public static String getOsVersion() {
        return System.getProperty("os.version");
    }

    public static String getArch() {
        return System.getProperty("os.arch");
    }

    public static long getProcessId() {
        return JvmProcessIdInfo.get();
    }

    public static List<String> getIpAddresses() {
        return LocalNetworkInterfaceInfo.get();
    }
}

