/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public final class ValidationResult {
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public boolean isEmpty() {
        return this.errors.isEmpty() && this.warnings.isEmpty();
    }

    public ValidationResult addError(String error) {
        this.errors.add(error);
        return this;
    }

    public ValidationResult addErrors(List<String> errors) {
        this.errors.addAll(errors);
        return this;
    }

    public ValidationResult addErrors(String ... errors) {
        this.errors.addAll(Arrays.asList(errors));
        return this;
    }

    public ValidationResult addWarning(String warning) {
        this.warnings.add(warning);
        return this;
    }

    public ValidationResult addWarnings(List<String> warnings) {
        this.warnings.addAll(warnings);
        return this;
    }

    public ValidationResult addWarnings(String ... warnings) {
        this.warnings.addAll(Arrays.asList(warnings));
        return this;
    }

    public ValidationResult add(ValidationResult otherResult) {
        this.errors.addAll(otherResult.errors);
        this.warnings.addAll(otherResult.warnings);
        return this;
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public void logAll(Logger logger, String prefix, String suffix) {
        this.logErrors(logger, prefix, suffix);
        this.logWarnings(logger, prefix, suffix);
    }

    public void logAll(Logger logger, String prefix) {
        this.logErrors(logger, prefix);
        this.logWarnings(logger, prefix);
    }

    public void logAll(Logger logger) {
        this.logErrors(logger);
        this.logWarnings(logger);
    }

    public void logErrors(Logger logger, String prefix, String suffix) {
        for (String errorMessage : this.errors) {
            logger.error(prefix + errorMessage + suffix);
        }
    }

    public void logErrors(Logger logger, String prefix) {
        this.logErrors(logger, prefix, "");
    }

    public void logErrors(Logger logger) {
        this.logErrors(logger, "", "");
    }

    public void logWarnings(Logger logger, String prefix, String suffix) {
        for (String warningMessage : this.warnings) {
            logger.warn(prefix + warningMessage + suffix);
        }
    }

    public void logWarnings(Logger logger, String prefix) {
        this.logWarnings(logger, prefix, "");
    }

    public void logWarnings(Logger logger) {
        this.logWarnings(logger, "", "");
    }

    public String asString() {
        if (this.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String warnings = this.toStringWarnings();
        String errors = this.toStringErrors();
        if (warnings != null) {
            builder.append(warnings);
        }
        if (errors != null) {
            builder.append(errors);
        }
        return builder.toString();
    }

    public String toStringWarnings() {
        if (!this.warnings.isEmpty()) {
            return "warnings: " + this.warnings.toString();
        }
        return null;
    }

    public String toStringErrors() {
        if (!this.errors.isEmpty()) {
            return "errors: " + this.errors.toString();
        }
        return null;
    }

    @Generated
    public ValidationResult() {
    }

    @Generated
    public List<String> getErrors() {
        return this.errors;
    }

    @Generated
    public List<String> getWarnings() {
        return this.warnings;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationResult)) {
            return false;
        }
        ValidationResult other = (ValidationResult)o;
        List<String> this$errors = this.getErrors();
        List<String> other$errors = other.getErrors();
        if (this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors)) {
            return false;
        }
        List<String> this$warnings = this.getWarnings();
        List<String> other$warnings = other.getWarnings();
        return !(this$warnings == null ? other$warnings != null : !((Object)this$warnings).equals(other$warnings));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        List<String> $warnings = this.getWarnings();
        result = result * 59 + ($warnings == null ? 43 : ((Object)$warnings).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidationResult(errors=" + this.getErrors() + ", warnings=" + this.getWarnings() + ")";
    }
}

