/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration.validation;

import io.sealights.onpremise.agents.infra.configuration.validation.ConfigValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.SourceVersion;

public class PackagesIncludedValidator
implements ConfigValidator<String> {
    public static final String MISSING_PACKAGESINCLUDED_MESSAGE = "Missing build session setting - 'packagesIncluded'.";
    public static final String INVALID_FORMAT_MESSAGE_TEMPLATE = "'%s' is an invalid package input: it contains illegal character(s).";
    public static final String PACKAGE_ENDS_WITH_DOT_TEMPLATE = "'%s' is an invalid package input: ends with dot '.'.";
    public static final String FORBIDDEN_PACKAGE_MESSAGE_TEMPLATE = "Package name '%s' is forbidden in the 'packagesIncluded'.";
    public static final List<String> FORBIDDEN_PACKAGES = Arrays.asList("*", "com.*", "io.*", "java.*", "javax.*", "net.*", "org.*");
    private static final String PACKAGE_SEPARATOR = ",";
    private static final char WILDCARD_STAR = '*';
    private static final char ONE_CHARACTER_WILDCARD = '?';
    private static final String DOT = ".";
    private static final String ESCAPED_DOT = "\\.";
    private static final char ACCEPTABLE_CHARACTER = 'x';

    @Override
    public ValidationResult validate(String packages) {
        ValidationResult result = new ValidationResult();
        if (StringUtils.isNullOrEmpty(packages)) {
            return result.addError(MISSING_PACKAGESINCLUDED_MESSAGE);
        }
        String[] splitPackages = packages.split(PACKAGE_SEPARATOR);
        result.addErrors(this.checkPackageIdentifiers(splitPackages));
        result.addErrors(this.validateAgainstForbiddenPackageNames(splitPackages));
        return result;
    }

    private List<String> validateAgainstForbiddenPackageNames(String[] packages) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String pkg : packages) {
            for (String forbiddenPackageName : FORBIDDEN_PACKAGES) {
                if (!forbiddenPackageName.equals(pkg)) continue;
                errors.add(String.format(FORBIDDEN_PACKAGE_MESSAGE_TEMPLATE, pkg));
            }
        }
        return errors;
    }

    private List<String> checkPackageIdentifiers(String[] packages) {
        ArrayList<String> errors = new ArrayList<String>();
        for (String pkg : packages) {
            this.checkPackageIdentifier(errors, pkg.trim());
        }
        return errors;
    }

    protected void checkPackageIdentifier(List<String> errors, String trimmedPkg) {
        if (!this.isValidPackageToken(trimmedPkg)) {
            errors.add(String.format(INVALID_FORMAT_MESSAGE_TEMPLATE, trimmedPkg));
        }
        if (this.endsWithDot(trimmedPkg)) {
            errors.add(String.format(PACKAGE_ENDS_WITH_DOT_TEMPLATE, trimmedPkg));
        }
    }

    private boolean isValidPackageToken(String packageToken) {
        for (String pkgIdentifier : packageToken.split(ESCAPED_DOT)) {
            String concreteIdentifier = pkgIdentifier.replace('*', 'x').replace('?', 'x');
            if (SourceVersion.isIdentifier(concreteIdentifier)) continue;
            return false;
        }
        return true;
    }

    private boolean endsWithDot(String s2) {
        return s2.endsWith(DOT);
    }
}

