/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration.stringable;

import io.sealights.onpremise.agents.infra.configuration.stringable.PropConverters;

public abstract class TypePropertyConverter<T>
extends PropConverters.PropertyConverter<T> {
    protected static final String ATTR_CONVERT_FMT = "%s.%s=%s";
    protected static final String ITERATE_FMT = "%s.%s=%s, ";

    public TypePropertyConverter() {
    }

    public TypePropertyConverter(String name, T value) {
        super(name, value);
    }

    @Override
    public String convert() {
        if (this.getValue() != null) {
            return this.convertAttrs();
        }
        return this.convertNullPropValue();
    }

    protected String toStringAttr(String attrName, Object attrValue) {
        return this.toStrAttrInList(attrName, attrValue, false);
    }

    protected String toStringLastAttr(String attrName, Object attrValue) {
        return this.toStrAttrInList(attrName, attrValue, true);
    }

    protected String toStringNullValueAttr(String attrName) {
        return this.toStrNullValueAttrInList(attrName, false);
    }

    protected String toStringNullValueLastAttr(String attrName) {
        return this.toStrNullValueAttrInList(attrName, true);
    }

    protected String toStrAttrInList(String attrName, Object attrValue, boolean isLast) {
        if (attrValue == null) {
            return this.toStrNullValueAttrInList(attrName, isLast);
        }
        String currentFmt = isLast ? ATTR_CONVERT_FMT : ITERATE_FMT;
        return String.format(currentFmt, this.getName(), attrName, attrValue);
    }

    protected String toStrNullValueAttrInList(String attrName, boolean isLast) {
        String currentFmt = isLast ? ATTR_CONVERT_FMT : ITERATE_FMT;
        return String.format(currentFmt, this.getName(), attrName, "null");
    }

    protected abstract String convertAttrs();
}

