/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration.stringable;

import io.sealights.onpremise.agents.infra.configuration.stringable.PropConverters;
import io.sealights.onpremise.agents.infra.configuration.stringable.TypePropertyConverter;
import java.util.List;

public class TypeListPropertyConverter<V>
extends PropConverters.PropertyConverter<List<V>> {
    private TypePropertyConverter<V> typeConverter;

    public TypeListPropertyConverter(String name, List<V> value, TypePropertyConverter<V> typeConverter) {
        super(name, value);
        this.typeConverter = typeConverter;
    }

    @Override
    public String convert() {
        this.typeConverter.setName(this.getName());
        StringBuilder builder = new StringBuilder();
        if (this.getValue() == null) {
            return this.convertNullPropValue();
        }
        if (((List)this.getValue()).isEmpty()) {
            return this.convertEmptyPropValue();
        }
        int last = ((List)this.getValue()).size() - 1;
        int current = 0;
        for (Object entry : (List)this.getValue()) {
            this.typeConverter.setValue(entry);
            builder.append(this.toStringEntry(entry, current, current == last));
            ++current;
        }
        return builder.toString();
    }

    private String toStringEntry(V entry, int index, boolean isLast) {
        this.typeConverter.setName(String.format("%s_%s", this.getName(), index));
        this.typeConverter.setValue(entry);
        String converted = this.typeConverter.convert();
        if (isLast) {
            return converted;
        }
        return converted + ", ";
    }
}

