/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration.stringable;

import java.util.List;
import lombok.Generated;

public class PropConverters {
    public static final String NULL_VALUE = "null";

    public static class SimpleListPropertyConverter<V>
    extends PropertyConverter<List<V>> {
        public SimpleListPropertyConverter(String name, List<V> value) {
            super(name, value);
        }

        @Override
        public String convert() {
            if (this.getValue() == null) {
                return this.convertNullPropValue();
            }
            if (((List)this.getValue()).isEmpty()) {
                return this.convertEmptyPropValue();
            }
            return this.allValuesToString();
        }

        private String allValuesToString() {
            StringBuilder builder = new StringBuilder();
            int last = ((List)this.getValue()).size() - 1;
            int current = 0;
            for (Object val : (List)this.getValue()) {
                builder.append(val != null ? val.toString() : PropConverters.NULL_VALUE);
                if (current < last) {
                    builder.append(", ");
                }
                ++current;
            }
            return builder.toString();
        }
    }

    public static class SimplePropertyConverter
    extends PropertyConverter<Object> {
        public SimplePropertyConverter(String name, Object value) {
            super(name, value);
        }

        @Override
        public String convert() {
            if (this.getValue() == null) {
                return this.convertNullPropValue();
            }
            return this.getValue().toString();
        }
    }

    public static abstract class PropertyConverter<T> {
        protected static final String EMPTY_VALUE = "empty";
        protected static final String CONTINUE_LIST = ", ";
        private String name;
        private T value;

        protected PropertyConverter() {
        }

        protected PropertyConverter(String name, T value) {
            this.name = name;
            this.value = value;
        }

        protected String convertNullPropValue() {
            return PropConverters.NULL_VALUE;
        }

        protected String convertEmptyPropValue() {
            return EMPTY_VALUE;
        }

        public abstract String convert();

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public T getValue() {
            return this.value;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValue(T value) {
            this.value = value;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PropertyConverter)) {
                return false;
            }
            PropertyConverter other = (PropertyConverter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            T this$value = this.getValue();
            T other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PropertyConverter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            T $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PropConverters.PropertyConverter(name=" + this.getName() + ", value=" + this.getValue() + ")";
        }
    }
}

