/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.Properties;
import lombok.Generated;

public final class SLPropertiesFilter {
    public static Properties getAll() {
        return SLPropertiesFilter.select(null);
    }

    public static Properties getSelected(String filter) {
        return SLPropertiesFilter.select(filter);
    }

    public static Properties getFeaturesProps() {
        return SLPropertiesFilter.select("sl.featuresData");
    }

    private static Properties select(String filter) {
        Properties slProps = new Properties();
        Properties sysProps = System.getProperties();
        for (String property : sysProps.stringPropertyNames()) {
            if (!SLPropertiesFilter.isSlProperty(property) || !SLPropertiesFilter.matchFilter(property, filter)) continue;
            String value = sysProps.getProperty(property);
            value = StringUtils.removeWrappingQuotes(value);
            slProps.put(property, value);
        }
        return slProps;
    }

    private static boolean matchFilter(String propertyName, String filter) {
        return StringUtils.isNullOrEmpty(filter) ? true : propertyName.toLowerCase().contains(filter.toLowerCase());
    }

    public static boolean isSlProperty(String propertyName) {
        return propertyName.toLowerCase().startsWith("sl.");
    }

    @Generated
    private SLPropertiesFilter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

