/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.configuration.CIProps;
import io.sealights.onpremise.agents.infra.configuration.SLAgentFlexConfiguration;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenParser;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import lombok.Generated;

public class SLBaseSettings {
    protected static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    protected static final String END_INIT_TOKEN = "... Init token]";
    protected static final String START_INIT_TOKEN = "[Init token ...";
    private TokenData tokenData;
    private String token;

    public String getTokenFromSysProperies() {
        return ArgumentFileReader.resolve(System.getProperty("sl.token"), System.getProperty("sl.tokenFile"));
    }

    public String resolveConfigToken(SLAgentFlexConfiguration configuration) {
        return ArgumentFileReader.resolve(configuration.getToken(), configuration.getTokenFile());
    }

    public String getBuildSessionIdFromSysProperies() {
        return ArgumentFileReader.resolve(System.getProperty("sl.buildSessionId"), System.getProperty("sl.buildSessionIdFile"));
    }

    public String resolveConfigBuildSessionId(SLAgentFlexConfiguration configuration) {
        return ArgumentFileReader.resolve(configuration.getBuildSessionId(), configuration.getBuildSessionIdFile());
    }

    public boolean applyTokenDataIfValid(String tokenValue) {
        this.tokenData = TokenParser.parseAndValidate(tokenValue);
        if (!this.tokenData.isValid()) {
            CONSOLE_LOG.error("Invalid token: {}, tokenValue:'{}'", (Object)this.tokenData.toStringErrors(), (Object)tokenValue);
            CONSOLE_LOG.info(END_INIT_TOKEN);
            return false;
        }
        this.token = tokenValue;
        CIProps.setProperty("sl.token", tokenValue);
        CIProps.setProperty("sl.customerId", this.tokenData.getCustomerId());
        if (CIProps.getProperty("sl.server") == null) {
            CIProps.setProperty("sl.server", this.tokenData.getServer());
        }
        CONSOLE_LOG.info(END_INIT_TOKEN);
        return true;
    }

    protected String getConsoleTag() {
        return CONSOLE_LOG.getPrefix();
    }

    @Generated
    public TokenData getTokenData() {
        return this.tokenData;
    }

    @Generated
    public String getToken() {
        return this.token;
    }
}

