/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;

public final class SLAgentConfigurationFileReader {
    private static Logger LOG = LogFactory.getLogger(SLAgentConfigurationFileReader.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String FILE_NOT_FOUND_FMT = "Configuration file '%s' not exists in working directory '%s'";
    private static final String CONFIG_READ_FAILED_FMT = "Failed to read configuration from file '%s' in working directory '%s'";

    public static <T extends SLAgentConfiguration> T loadConfigurationFromFile(String configFileName, Class<T> configurationClass, ExceptionToCockpitHandler exceptionToCockpitHandler) {
        if (StringUtils.isNullOrEmpty(configFileName = SLAgentConfigurationFileReader.tryUseConfigFileSysProperty(configFileName))) {
            LOG.info("No configuration file was provided; configuration will be resolved from system properties");
            return null;
        }
        LOG.debug("Try load configuration from '{}', working directory: '{}' ...", (Object)configFileName, (Object)DefaultDirs.WORKING_DIR);
        SLAgentConfiguration configuration = null;
        try {
            File configFile = new File(configFileName);
            if (!configFile.exists()) {
                LOG.debug(String.format(FILE_NOT_FOUND_FMT, configFile, DefaultDirs.WORKING_DIR));
            } else {
                configuration = (SLAgentConfiguration)JsonObjectMapper.toObject(configFile, configurationClass);
                if (configuration != null) {
                    LOG.debug("Configuration loaded from file: {}", (Object)configuration);
                } else {
                    SLAgentConfigurationFileReader.logError(String.format(CONFIG_READ_FAILED_FMT, configFileName, DefaultDirs.WORKING_DIR));
                }
            }
        }
        catch (Exception e) {
            SLAgentConfigurationFileReader.logError(String.format(CONFIG_READ_FAILED_FMT, configFileName, DefaultDirs.WORKING_DIR), e, exceptionToCockpitHandler);
        }
        return (T)configuration;
    }

    public static <T extends SLAgentConfiguration> T loadConfigurationFromFile(String configFileName, Class<T> configurationClass) {
        return SLAgentConfigurationFileReader.loadConfigurationFromFile(configFileName, configurationClass, null);
    }

    protected static String tryUseConfigFileSysProperty(String configFileName) {
        String propertValue = System.getProperty("sl.config.file");
        if (StringUtils.isNotEmpty(propertValue)) {
            return propertValue;
        }
        return configFileName;
    }

    private static void logError(String error) {
        LOG.error(error);
        CONSOLE_LOG.info(error);
    }

    private static void logError(String error, Exception e, ExceptionToCockpitHandler exceptionHandler) {
        if (exceptionHandler != null) {
            exceptionHandler.execute(error, e);
        } else {
            LOG.error(error, e);
        }
        CONSOLE_LOG.info(error, e);
    }

    @Generated
    private SLAgentConfigurationFileReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface ExceptionToCockpitHandler {
        public void execute(String var1, Exception var2);
    }
}

