/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.infra.configuration;

import io.sealights.onpremise.agents.infra.configuration.SLPropertiesFilter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.Properties;

public final class PropertiesFileWriter {
    public static void createFileFromSystemProps(String propsFileTarget) throws IOException {
        Properties slProps = SLPropertiesFilter.getAll();
        if (!slProps.isEmpty()) {
            File slPropsFile = PropertiesFileWriter.validatePropsFileTarget(propsFileTarget);
            PropertiesFileWriter.storePropsFile(slProps, slPropsFile);
        }
    }

    private static void storePropsFile(Properties slProps, File slPropsFile) throws IOException {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(slPropsFile);
            slProps.store(fileOut, "Sealights configuration properties");
            fileOut.close();
        }
        catch (IOException e) {
            throw new IOException("Unable store properties at file '" + slPropsFile.getAbsolutePath() + "'", e);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static File validatePropsFileTarget(String targetPropertiesFile) throws IOException {
        boolean isCreatedFile;
        File slPropsFile = new File(targetPropertiesFile);
        if (slPropsFile.exists()) {
            throw new FileAlreadyExistsException("file '" + targetPropertiesFile + "' already exist.");
        }
        try {
            isCreatedFile = slPropsFile.createNewFile();
        }
        catch (IOException e) {
            throw new IOException("Unable to create properties file at '" + targetPropertiesFile + "'", e);
        }
        if (!isCreatedFile) {
            throw new IOException("Unable to create properties file at '" + targetPropertiesFile + "'");
        }
        return slPropsFile;
    }

    private PropertiesFileWriter() {
    }
}

