/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.events;

import io.sealights.onpremise.agents.events.AgentInternalEvent;
import io.sealights.onpremise.agents.events.AgentInternalEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AgentInternalEventsNotifier {
    private final ConcurrentMap<Class<? extends AgentInternalEvent>, List<AgentInternalEventListener>> listenersMap = new ConcurrentHashMap<Class<? extends AgentInternalEvent>, List<AgentInternalEventListener>>();

    public <T extends AgentInternalEvent> void addListener(Class<T> eventType, AgentInternalEventListener<T> listener) {
        if (eventType == null || listener == null) {
            return;
        }
        this.listenersMap.computeIfAbsent(eventType, e -> new ArrayList()).add(listener);
    }

    public void notifyListeners(AgentInternalEvent agentInternalEvent) {
        List<AgentInternalEventListener> agentInternalEventListeners = this.listenersMap.getOrDefault(agentInternalEvent.getClass(), Collections.EMPTY_LIST);
        agentInternalEventListeners.forEach(l -> l.handleEvent(agentInternalEvent));
    }
}

