/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.watchdog;

import io.sealights.onpremise.agents.commons.functions.FunctionsChain;
import io.sealights.onpremise.agents.commons.functions.Procedure;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;

public class Watchdog {
    private static Logger LOG = LogFactory.getLogger(Watchdog.class);
    private ScheduledExecutorService scheduledExecutor;
    private int delayMSecs;
    private int intervalMSecs;
    private String name;
    private Procedure onDoWorkHandler;
    private volatile boolean isStopping = false;
    ScheduledFuture<?> workToBeDone = null;

    public Watchdog(ScheduledExecutorService scheduledExecutor, int delayMSecs, int intervalMSecs, String name) {
        this.scheduledExecutor = scheduledExecutor;
        this.delayMSecs = delayMSecs;
        this.intervalMSecs = intervalMSecs;
        this.name = name;
    }

    public synchronized void start() {
        this.scheduleWork(this.delayMSecs, this.intervalMSecs);
    }

    public synchronized void stop() {
        this.isStopping = true;
        this.abortTimer();
        this.shutdown();
    }

    private void shutdown() {
        try {
            LogFactory.getLogManager().setThreadContext();
            this.scheduledExecutor.shutdown();
            this.scheduledExecutor.awaitTermination(60L, TimeUnit.SECONDS);
            LOG.debug("Timer '{}' shutted down", (Object)this.name);
        }
        catch (InterruptedException e) {
            new RuntimeException(e);
        }
    }

    public synchronized void reset() {
        this.abortTimer();
        if (!this.isStopping) {
            this.scheduleWork(this.intervalMSecs, this.intervalMSecs);
        }
    }

    public void addOnDoWorkHandler(Procedure handler) {
        this.onDoWorkHandler = FunctionsChain.combine(this.onDoWorkHandler, handler);
    }

    public void removeOnDoWorkHandler(Procedure handler) {
        this.onDoWorkHandler = FunctionsChain.remove(this.onDoWorkHandler, handler);
    }

    private void abortTimer() {
        if (this.workToBeDone != null) {
            boolean mayInterruptIfRunning = false;
            this.workToBeDone.cancel(mayInterruptIfRunning);
            this.workToBeDone = null;
            LOG.debug("Timer '{}' aborted", (Object)this.name);
        }
    }

    private void scheduleWork(int delayMSecs, final int intervalMSecs) {
        if (this.isStopping) {
            return;
        }
        this.workToBeDone = this.scheduledExecutor.schedule(new Runnable(){

            @Override
            public void run() {
                try {
                    LogFactory.getLogManager().setThreadContext();
                    if (Watchdog.this.isStopping) {
                        return;
                    }
                    Watchdog.this.onDoWork();
                    if (intervalMSecs > 0) {
                        Watchdog.this.scheduleWork(intervalMSecs, intervalMSecs);
                    }
                }
                catch (Throwable t) {
                    LOG.error("Unrecoverable error occurred on timer '{}' execution. Timer will not be rerun,", (Object)Watchdog.this.name, (Object)t);
                }
            }
        }, (long)delayMSecs, TimeUnit.MILLISECONDS);
    }

    private void onDoWork() {
        if (this.onDoWorkHandler != null) {
            LOG.debug("Timer '{}' going to execute work", (Object)this.name);
            try {
                this.onDoWorkHandler.execute();
            }
            catch (Throwable e) {
                LOG.error("Exception happens on timer '{}' execution, proceed for the next cycle; error:", (Object)this.name, (Object)e);
            }
        }
    }

    @Generated
    public ScheduledExecutorService getScheduledExecutor() {
        return this.scheduledExecutor;
    }
}

