/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.watchdog;

import io.sealights.onpremise.agents.commons.watchdog.Watchdog;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;

public final class WatchDogFactory {
    public static Watchdog createRepeatedWatchdog(int interval, String threadPoolName) {
        ScheduledExecutorService scheduledExecutor = WatchDogFactory.createScheduledExecutorService(threadPoolName);
        Watchdog watchdog = new Watchdog(scheduledExecutor, interval, interval, threadPoolName);
        return watchdog;
    }

    public static Watchdog createRepeatedWatchdog(int delayMsecs, int interval, String threadPoolName) {
        ScheduledExecutorService scheduledExecutor = WatchDogFactory.createScheduledExecutorService(threadPoolName);
        Watchdog watchdog = new Watchdog(scheduledExecutor, delayMsecs, interval, threadPoolName);
        return watchdog;
    }

    public static Watchdog createOneTimeWatchdog(String threadPoolName, int delayMsecs) {
        ScheduledExecutorService scheduledExecutor = WatchDogFactory.createScheduledExecutorService(threadPoolName);
        Watchdog watchdog = new Watchdog(scheduledExecutor, delayMsecs, 0, threadPoolName);
        return watchdog;
    }

    protected static ScheduledExecutorService createScheduledExecutorService(final String threadPoolName) {
        ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread2 = Executors.defaultThreadFactory().newThread(runnable);
                thread2.setName(threadPoolName);
                thread2.setDaemon(true);
                LogFactory.getLogManager().setThreadContext();
                return thread2;
            }
        });
        return scheduledExecutorService;
    }

    private WatchDogFactory() {
    }
}

