/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.utils;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;

public class ZipUtils {
    private static Logger LOG = LogFactory.getLogger(ZipUtils.class);

    public static void pack(final Path folder, Path zipFilePath) throws IOException {
        Files.deleteIfExists(zipFilePath);
        try (FileOutputStream fos = new FileOutputStream(zipFilePath.toFile());
             final ZipOutputStream zos = new ZipOutputStream(fos);){
            Files.walkFileTree(folder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(folder.relativize(file).toString()));
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    zos.putNextEntry(new ZipEntry(folder.relativize(dir) + "/"));
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }
}

