/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.queues;

import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;

public class QueueDataSendMonitor {
    private static Logger LOG = LogFactory.getLogger(QueueDataSendMonitor.class);
    private static final String ONE_SUBMIT_FAILED_MSG_FMT = "Failed to send %s; data will be resent";
    private static final String CONSEQUENT_SUBMIT_FAILED_MSG_FMT = "Consequently failed to send %s; data will be resent again";
    private static final String SUBMIT_FAILED_ON_END_EXECUTION_MSG_FMT = "Failed to send %s on end execution for test stage '%s'";
    private static final String SUBMIT_FAILED_ON_SHUTDOWN_MSG_FMT = "Failed to send %s during shutdown";
    private static final String QUEUE_FULL_MSG_FMT = "Dropping %s after send failure due to queue overflow";
    private static final String SUMMARY_MSG = "%s send summary - ";
    private final String queueItemName;
    private final AgentEventCode submitErrorCode;
    private AtomicBoolean shuttingDown = new AtomicBoolean(false);
    private Counter sequentialFailuresCtr = new Counter();
    private Counter successCtr = new Counter();
    private Throwable currentError;

    public QueueDataSendMonitor(String queueItemName, AgentEventCode submitErrorCode) {
        this.queueItemName = queueItemName;
        this.submitErrorCode = submitErrorCode;
    }

    public synchronized void onFailure(List<?> queueContents, Throwable e) {
        this.sequentialFailuresCtr.incRequests(queueContents.size());
        this.currentError = e;
    }

    public synchronized void onSuccess(List<?> queueContents) {
        this.successCtr.incRequests(queueContents.size());
        this.resetErrors();
    }

    private void resetErrors() {
        this.sequentialFailuresCtr.reset();
        this.currentError = null;
    }

    public synchronized void notifyCurrentError(boolean queueIsFull) {
        try {
            if (queueIsFull) {
                this.notifyDataLossError();
                return;
            }
            if (this.isShuttingDown()) {
                this.notifyShutdownError();
            } else {
                this.notifyRecoverableError();
            }
        }
        finally {
            this.currentError = null;
        }
    }

    public synchronized void notifyErrorsOnEndExecution(String testStage) {
        if (this.sequentialFailuresCtr.getRequests() == 0L || this.currentError == null) {
            return;
        }
        this.notifySubmitError(this.buildMessage(this.buildSubmitOnEndExecutionFailureMsg(testStage)));
        this.resetErrors();
    }

    public synchronized void notifyWorkSummary() {
        StringBuilder builder = new StringBuilder(this.buildSummaryMsg());
        builder.append("success counters:").append(this.successCtr);
        if (this.isInFailure()) {
            builder.append(", recent sequential failures counters:").append(this.sequentialFailuresCtr);
        }
        LOG.info(builder.toString());
        AgentLifeCycle.notifyInfoMsg(builder.toString());
    }

    public boolean isShuttingDown() {
        return this.shuttingDown.get();
    }

    public void setShuttingDown() {
        this.shuttingDown.set(true);
    }

    public String buildSingleSubmitFailureMsg() {
        return String.format(ONE_SUBMIT_FAILED_MSG_FMT, this.queueItemName);
    }

    public String buildConsequentSubmitFailureMsg() {
        return String.format(CONSEQUENT_SUBMIT_FAILED_MSG_FMT, this.queueItemName);
    }

    public String buildSubmitOnEndExecutionFailureMsg(String testStage) {
        return String.format(SUBMIT_FAILED_ON_END_EXECUTION_MSG_FMT, this.queueItemName, testStage);
    }

    public String buildSubmitOnShutdownFailureMsg() {
        return String.format(SUBMIT_FAILED_ON_SHUTDOWN_MSG_FMT, this.queueItemName);
    }

    public String buildQueueFullFailureMsg() {
        return String.format(QUEUE_FULL_MSG_FMT, this.queueItemName);
    }

    public String buildSummaryMsg() {
        return String.format(SUMMARY_MSG, this.queueItemName);
    }

    private void notifyDataLossError() {
        this.notifySubmitError(this.buildMessage(this.buildQueueFullFailureMsg()));
    }

    private void notifyShutdownError() {
        this.notifySubmitError(this.buildMessage(this.buildSubmitOnShutdownFailureMsg()));
    }

    private void notifySubmitError(String errorMsg) {
        AgentLifeCycle.notifyMsgEvent(this.submitErrorCode, errorMsg);
        LOG.error(errorMsg);
    }

    private String buildMessage(String prefix) {
        StringBuilder builder = new StringBuilder(prefix);
        if (this.sequentialFailuresCtr.getRequests() == 1L) {
            builder.append(", ").append(this.toStringCurrentError());
        } else {
            builder.append(", ").append(this.toStringSequentialFailuresInfo());
        }
        return builder.toString();
    }

    private void notifyRecoverableError() {
        if (this.sequentialFailuresCtr.getRequests() == 0L || this.currentError == null) {
            return;
        }
        if (this.sequentialFailuresCtr.getRequests() == 1L) {
            AgentLifeCycle.notifyInfoMsg(String.format("%s, %s", this.buildSingleSubmitFailureMsg(), this.toStringCurrentError()));
        } else {
            AgentLifeCycle.notifyInfoMsg(String.format("%s, %s", this.buildConsequentSubmitFailureMsg(), this.toStringSequentialFailuresInfo()));
        }
    }

    private String toStringCurrentError() {
        return String.format("error: %s", this.currentError.toString());
    }

    private String toStringSequentialFailuresInfo() {
        return String.format("%s sequential requests failed, last error: %s", this.sequentialFailuresCtr.getRequests(), this.currentError.toString());
    }

    private boolean isInFailure() {
        return this.sequentialFailuresCtr.getRequests() > 0L;
    }

    @Generated
    public AgentEventCode getSubmitErrorCode() {
        return this.submitErrorCode;
    }

    @Generated
    public Counter getSequentialFailuresCtr() {
        return this.sequentialFailuresCtr;
    }

    @Generated
    public Counter getSuccessCtr() {
        return this.successCtr;
    }

    @Generated
    public Throwable getCurrentError() {
        return this.currentError;
    }

    public static class Counter {
        private long requests;
        private long items;

        void incRequests(int addItems) {
            ++this.requests;
            this.items += (long)addItems;
        }

        void reset() {
            this.requests = 0L;
            this.items = 0L;
        }

        public String toString() {
            return String.format("(requests=%s, items=%s)", this.requests, this.items);
        }

        @Generated
        public Counter() {
        }

        @Generated
        public long getRequests() {
            return this.requests;
        }

        @Generated
        public long getItems() {
            return this.items;
        }

        @Generated
        public void setRequests(long requests) {
            this.requests = requests;
        }

        @Generated
        public void setItems(long items) {
            this.items = items;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Counter)) {
                return false;
            }
            Counter other = (Counter)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRequests() != other.getRequests()) {
                return false;
            }
            return this.getItems() == other.getItems();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Counter;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $requests = this.getRequests();
            result = result * 59 + (int)($requests >>> 32 ^ $requests);
            long $items = this.getItems();
            result = result * 59 + (int)($items >>> 32 ^ $items);
            return result;
        }
    }
}

