/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.main;

import io.sealights.onpremise.agents.commons.EmbeddedJarUtils;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.env.JvmEnvInfoCollector;
import io.sealights.onpremise.agents.infra.environment.DefaultEnvironmentInfo;
import io.sealights.onpremise.agents.infra.utils.jvm.CodeRunner;
import java.io.File;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import lombok.Generated;

public final class PreMainHelper {
    public static final String PREMAIN_METHOD = "premain";
    private static final String AGENTMAIN_METHOD = "agentmain";
    private static final String MAIN_METHOD = "main";
    private static final String ADD_URL_METHOD = "addURL";
    private static final String APPEND_TO_CLASS_PATH_JAVA9 = "appendToClassPathForInstrumentation";

    public static void addCoreJarToClasspath(ClassLoader classLoader, Class<?> preMainClass, String coreJarName) throws Exception {
        File coreJar = PreMainHelper.createTempCoreJarFile(preMainClass, coreJarName);
        if (coreJar == null) {
            throw new RuntimeException("Failed to create temporary core jar, Sealights will not run");
        }
        PreMainHelper.tryAddJarToClasspath(coreJar, classLoader);
    }

    public static void tryAddJarToClasspath(final File jar, final ClassLoader classLoader) {
        CodeRunner.executeWithSilentException(new CodeRunner.CodeWithException(){

            @Override
            public void run() throws Throwable {
                if (classLoader == null) {
                    return;
                }
                Class<?> clazz = classLoader.getClass();
                if (JvmEnvInfoCollector.isPreJava9()) {
                    PreMainHelper.addJarToClassPathPreJava9(clazz, jar, classLoader);
                } else {
                    PreMainHelper.addJarToClassPathPostJava9(clazz, jar, classLoader);
                }
            }
        });
    }

    private static void addJarToClassPathPreJava9(Class<?> clazz, File jar, ClassLoader classLoader) throws Exception {
        Method method = clazz.getSuperclass().getDeclaredMethod(ADD_URL_METHOD, URL.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, jar.toURI().toURL());
    }

    private static void addJarToClassPathPostJava9(Class<?> clazz, File jar, ClassLoader classLoader) throws Exception {
        Method method = clazz.getDeclaredMethod(APPEND_TO_CLASS_PATH_JAVA9, String.class);
        method.setAccessible(true);
        method.invoke((Object)classLoader, jar.getAbsolutePath());
    }

    public static File createTempCoreJarFile(Class<?> preMainClass, String coreJarName) throws Exception {
        String version = DefaultEnvironmentInfo.getAgentVersion();
        String jarNameWithoutExtension = coreJarName + version;
        return EmbeddedJarUtils.loadEmbeddedJarFile(jarNameWithoutExtension, System.getProperty("sl.fileStorage"));
    }

    public static Method getPremainMethod(ClassLoader classLoader, String className) throws ClassNotFoundException, NoSuchMethodException {
        Class[] argumentTypes = new Class[]{String.class, Instrumentation.class};
        return PreMainHelper.getMethod(className, PREMAIN_METHOD, classLoader, argumentTypes);
    }

    public static Method getAgentmainMethod(ClassLoader classLoader, String className) throws ClassNotFoundException, NoSuchMethodException {
        Class[] argumentTypes = new Class[]{String.class, Instrumentation.class};
        return PreMainHelper.getMethod(className, AGENTMAIN_METHOD, classLoader, argumentTypes);
    }

    public static Method getMainMethod(ClassLoader classLoader, String className) throws ClassNotFoundException, NoSuchMethodException {
        Class[] argumentTypes = new Class[]{String[].class};
        return PreMainHelper.getMethod(className, MAIN_METHOD, classLoader, argumentTypes);
    }

    public static Method getMainMethodOfClassInJar(File jar, ClassLoader classLoader, String className) throws MalformedURLException, ClassNotFoundException, NoSuchMethodException {
        Class[] argumentTypes = new Class[]{String[].class};
        return PreMainHelper.getMethodOfClassInJar(jar, classLoader, className, MAIN_METHOD, argumentTypes);
    }

    public static Method getMethod(String className, String methodName, ClassLoader child, Class<?>[] argTypes) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> classToLoad = Class.forName(className, true, child);
        return classToLoad.getDeclaredMethod(methodName, argTypes);
    }

    public static Method getMethodOfClassInJar(File jar, ClassLoader classLoader, String className, String methodName, Class<?>[] methodArgs) throws MalformedURLException, ClassNotFoundException, NoSuchMethodException {
        URL[] urls = new URL[]{jar.toURI().toURL()};
        URLClassLoader child = new URLClassLoader(urls, classLoader);
        return PreMainHelper.getMethod(className, methodName, child, methodArgs);
    }

    public static String buildAgentVersionMessage(String message) {
        return String.format("%s agentID: '%s', version:'%s'", message, AgentId.getAgentId(), DefaultEnvironmentInfo.getAgentVersion());
    }

    @Generated
    private PreMainHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

