/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.main;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class JvmAgentOptionsParser {
    private static Logger LOG = LogFactory.getLogger(JvmAgentOptionsParser.class);
    private static final String COMMA = ",";
    private static final String K_To_V = "=";
    private String agentArgs;
    Map<String, String> argsValueMap = new HashMap<String, String>();

    public JvmAgentOptionsParser(String agentArgs) {
        this.agentArgs = agentArgs;
    }

    public Map<String, String> parse() {
        String[] options;
        if (StringUtils.isNullOrEmpty(this.agentArgs)) {
            LOG.info("No jvmAgent options were provided");
            return this.argsValueMap;
        }
        for (String o : options = this.agentArgs.split(COMMA)) {
            this.parseOption(o);
        }
        LOG.info("Parsed agentArguments: {}", (Object)this.argsValueMap);
        return this.argsValueMap;
    }

    public void parseOption(String option) {
        LOG.debug("Parsing option '{}'", (Object)option);
        String[] splits = option.split(K_To_V);
        switch (splits.length) {
            case 1: {
                this.parseUnsplittedOption(option);
                break;
            }
            case 2: {
                this.parseKeyValuePairOption(splits[0], splits[1], option);
                break;
            }
            default: {
                LOG.warn("Skipped unrecognized agent option format '{}'", (Object)option);
            }
        }
    }

    protected void parseUnsplittedOption(String option) {
        if (option.contains(K_To_V)) {
            LOG.warn("Skipped partial key/value agent option: '{}'", (Object)option);
        } else {
            LOG.debug("Argument without value", (Object)option);
            this.argsValueMap.put(option, null);
        }
    }

    protected void parseKeyValuePairOption(String key, String value, String option) {
        if (StringUtils.isNotEmpty(key) && StringUtils.isNotEmpty(value)) {
            LOG.debug("Parsed option: key='{}', value='{}'", (Object)key, (Object)value);
            this.argsValueMap.put(key, value);
        } else {
            LOG.debug("Skipped partial key/value agent option: '{}'", (Object)option);
        }
    }
}

