/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.lifecycle.events;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agentevents.engine.AgentEventsDispatcher;
import io.sealights.onpremise.agentevents.engine.AgentEventsFactory;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AnonymousExecutionEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.StringDataEvents;
import io.sealights.onpremise.agents.commons.ReflectionUtils;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentDescriptorCreator;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.configuration.stringable.StringableConfiguration;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.time.sync.utils.TimeClockDispatcher;
import io.sealights.onpremise.agents.infra.types.ExecutionDescriptor;
import io.sealights.onpremise.agents.infra.utils.threads.TaskScheduler;
import io.sealights.onpremise.agents.tcs.config.TimeClockSettings;
import java.util.Collection;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;

public class DefaultAgentEventsController
extends AgentEventsController
implements TaskScheduler.Task {
    private static Logger LOG = LogFactory.getLogger(DefaultAgentEventsController.class);
    private static final String PING_AGENT = "ping-agent";
    private SLAgentConfiguration configuration;
    private TaskScheduler pingSchedular;
    private static int DEFAULT_PING_INTERVAL_SEC = 120;

    public void init(AgentDescriptorCreator agentDescriptorCreator, SLAgentConfiguration configuration) {
        if (configuration == null) {
            LOG.warn("initialization cannot be done due to 'null' configuration");
            return;
        }
        if (this.getAgentDescriptor() == null) {
            this.configuration = configuration;
            LOG.debug(this.getConfiguration().toStringProperties("Updated configuration", true, false));
            super.init(agentDescriptorCreator.create(), configuration.getToken(), configuration.getServer(), configuration.getProxy());
            this.configureTimeClock();
            if (this.getAgentDescriptor().isSendsPing()) {
                this.initPingSchedular();
            }
        }
    }

    @Override
    public void stop() {
        this.stopPing();
        super.stop();
    }

    @Override
    public AgentStartInfo.ToolInfo getToolInfo() {
        return null;
    }

    @Override
    public Map<String, String> getConfigProperties() {
        StringableConfiguration.PropConvertList propConverts;
        if (this.configuration != null && (propConverts = this.configuration.createPropConverters()) != null) {
            return propConverts.asMap();
        }
        return null;
    }

    private void configureTimeClock() {
        SLAgentConfiguration slAgentConfiguration = this.getConfiguration();
        if (!"TestListenerConfiguration".equals(slAgentConfiguration.getClass().getSimpleName())) {
            LOG.debug("skip read timeClock from {} class", (Object)slAgentConfiguration.getClass());
            return;
        }
        try {
            TimeClockSettings tcSettings = (TimeClockSettings)ReflectionUtils.getFieldSafeSilent(this.getConfiguration(), "timeClock");
            if (null != tcSettings) {
                LOG.debug("is timeClock enabled: " + tcSettings.getEnabled());
                LOG.debug("timeClock sync interval [sec]: " + tcSettings.getSyncIntervalSec());
                this.getTimeClockDispatcher().enableTimeClock(tcSettings.getEnabled());
                this.getTimeClockDispatcher().getTimeClockServiceProxy().setTimeSyncIntervalSec(tcSettings.getSyncIntervalSec());
                LOG.debug("Updated Time Clock Sync configuration is applied to Time Clock Dispatcher. Enabled = " + this.getTimeClockDispatcher().isEnabled() + ", sync interval is set to " + this.getTimeClockDispatcher().getTimeClockServiceProxy().getTimeSyncIntervalSec() + " [sec]");
                this.verifyTimeClock(true);
            } else {
                LOG.info("TimeClock configuration not found in Remote Configuration");
                this.getTimeClockDispatcher().enableTimeClock(false);
                AgentEventsDispatcher dispatcher = this.getEventsDispatcher();
                if (null != dispatcher) {
                    dispatcher.addEvent(new StringDataEvents.GenericWarningEvent(TimeClockDispatcher.createCockpitMessage("timeClock setting not defined"), System.currentTimeMillis()));
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Error applying updated configuration to Time Clock Dispatcher.", ex);
        }
    }

    public void onConfigurationChanged(SLAgentConfiguration agentConfiguration) {
        this.configuration = agentConfiguration;
        LOG.debug(this.getConfiguration().toStringProperties("Updated configuration", true, false));
        this.configureTimeClock();
        this.sendConfigurationChangedEvent(agentConfiguration);
    }

    public void sendAnonymousExecutionEvent(boolean executionFound, ExecutionDescriptor executionData) {
        this.verifyTimeClock(false);
        AnonymousExecutionEvents.AnonymousExecutionEvent event = AgentEventsFactory.createAnonymousExecutionEvent(executionFound, executionData, this.timeClockDispatcher.getTimeClock());
        if (this.isValidDescriptor(event.getType())) {
            this.getEventsDispatcher().addEvent(event);
            LOG.info("{} event was sent, local time: {}, event timestamp: {}", event.getClass(), System.currentTimeMillis(), event.getUtcTimestamp_ms());
        }
    }

    @Override
    public void run() {
        this.sendPingEvent();
    }

    @Override
    public String getName() {
        return PING_AGENT;
    }

    protected void initPingSchedular() {
        int pingIntervalSecs = SystemPropertiesHelper.getIntProperty("sl.agentPingSec", DEFAULT_PING_INTERVAL_SEC);
        if (pingIntervalSecs <= 0) {
            LOG.info("ping interval is not defined (value={}), no ping event will be send", (Object)pingIntervalSecs);
            return;
        }
        LOG.info("ping will be send with interval {} secs", (Object)pingIntervalSecs);
        long pingIntervalMillis = TaskScheduler.toMillis(pingIntervalSecs);
        if (this.pingSchedular == null) {
            this.pingSchedular = new TaskScheduler(this.getName());
        }
        this.pingSchedular.assignTaskForRepeatedExecution(this, pingIntervalMillis);
    }

    protected void stopPing() {
        if (this.pingSchedular != null) {
            this.pingSchedular.stop();
        }
    }

    public void sendMsgCollectionEvent(AgentEventCode eventCode, Collection<String> strings) {
        this.verifyTimeClock(false);
        AgentEvent event = AgentEventsFactory.createStringCollectionAgentEvent(eventCode, strings, this.getTimeClockDispatcher().getTimeClock());
        if (this.isValidDescriptor(event.getType())) {
            this.getEventsDispatcher().addEvent(event);
        }
    }

    @Generated
    public DefaultAgentEventsController() {
    }

    @Generated
    public SLAgentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public void setConfiguration(SLAgentConfiguration configuration) {
        this.configuration = configuration;
    }

    @Generated
    public void setPingSchedular(TaskScheduler pingSchedular) {
        this.pingSchedular = pingSchedular;
    }
}

