/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.lifecycle.events;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.EndBuildEventRequest;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.FootprintsQueueOverflowEvent;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentDescriptorCreator;
import io.sealights.onpremise.agents.commons.lifecycle.events.DefaultAgentEventsController;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.types.ExecutionDescriptor;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;

public enum AgentLifeCycle {
    INSTANCE;

    private static Logger LOG;
    private DefaultAgentEventsController eventsController = new DefaultAgentEventsController();
    private static final boolean reportEvents;

    public static void initEventController(AgentDescriptorCreator agentDescriptorCreator, SLAgentConfiguration configuration) {
        AgentLifeCycle.INSTANCE.eventsController.init(agentDescriptorCreator, configuration);
    }

    public static boolean notifyStart(AgentDescriptorCreator descriptorCreator, SLAgentConfiguration configuration) {
        return AgentLifeCycle.notifyStart(descriptorCreator, configuration, true);
    }

    public static boolean notifyStart(AgentDescriptorCreator descriptorCreator, SLAgentConfiguration configuration, boolean createShutdownHook) {
        if (configuration == null) {
            LOG.warn("cannot send {} event due to 'null' configuration", (Object)AgentEventCode.AGENT_STARTED);
            return false;
        }
        LOG.info("starting ...");
        AgentLifeCycle.initEventController(descriptorCreator, configuration);
        AgentLifeCycle.notifyStart(createShutdownHook);
        return true;
    }

    public static void notifyStart(boolean createShutdownHook) {
        if (reportEvents) {
            AgentLifeCycle.INSTANCE.eventsController.sendStartEvent();
            if (createShutdownHook) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        AgentLifeCycle.notifyShutdown();
                    }
                });
            }
        }
    }

    public static void notifyStartError(AgentDescriptorCreator descriptorCreator, SLAgentConfiguration configuration, String error) {
        if (AgentLifeCycle.notifyStart(descriptorCreator, configuration)) {
            AgentLifeCycle.notifyErrorMsg(error);
        }
    }

    public static void notifyShutdown() {
        if (reportEvents) {
            LOG.info("shutting down ...");
            AgentLifeCycle.INSTANCE.eventsController.stop();
        }
    }

    public static void notifyErrorMsg(String error) {
        if (reportEvents) {
            AgentLifeCycle.INSTANCE.eventsController.sendMessage(AgentEventsController.NotifMsgLevel.ERROR, error);
            LOG.error(error);
        }
    }

    public static void notifyInstrumentMethodException(Class<?> scope, String methodName, Exception e) {
        AgentLifeCycle.notifyException(scope, String.format("Failed to instrument method '%s'", methodName), e);
    }

    public static void notifyException(Class<?> scope, String msg, Exception e) {
        AgentLifeCycle.notifyException(scope, msg, (Throwable)e);
    }

    public static void notifyExceptionWarning(Class<?> scope, String msg, Throwable e) {
        INSTANCE.handleExceptionMessage(scope, msg, e, AgentEventsController.NotifMsgLevel.WARNING);
    }

    public static void notifyException(Class<?> scope, String msg, Throwable e) {
        if (reportEvents) {
            INSTANCE.handleExceptionMessage(scope, msg, e, AgentEventsController.NotifMsgLevel.ERROR);
        }
    }

    public static void notifyExceptionInfo(Class<?> scope, String msg, Throwable e) {
        INSTANCE.handleExceptionMessage(scope, msg, e, AgentEventsController.NotifMsgLevel.INFO);
    }

    public static void notifyWarningMsg(String warning) {
        AgentLifeCycle.INSTANCE.eventsController.sendMessage(AgentEventsController.NotifMsgLevel.WARNING, warning);
        LOG.warn(warning);
    }

    public static void notifyInfoMsg(String msg) {
        AgentLifeCycle.INSTANCE.eventsController.sendMessage(AgentEventsController.NotifMsgLevel.INFO, msg);
    }

    public static void notifySuperUserMsg(AgentEventsController.NotifMsgLevel level, String msg) {
        AgentLifeCycle.INSTANCE.eventsController.sendSuperUserMessage(level, msg);
    }

    public static void notifyEvent(AgentEventCode eventCode) {
        AgentLifeCycle.INSTANCE.eventsController.sendSimpleEvent(eventCode);
    }

    public static void notifyEvent(AgentEvent agentEvent) {
        AgentLifeCycle.INSTANCE.eventsController.sendEvent(agentEvent);
    }

    public static void notifyMsgEvent(AgentEventCode eventCode, String msg) {
        AgentLifeCycle.INSTANCE.eventsController.sendMessageEvent(eventCode, msg);
    }

    public static void notifyFootprintsQueueOverflow(FootprintsQueueOverflowEvent event) {
        AgentLifeCycle.INSTANCE.eventsController.verifyTimeClock(false);
        if (null != AgentLifeCycle.INSTANCE.eventsController.getTimeClockDispatcher()) {
            event.setUtcTimestamp_ms(AgentLifeCycle.INSTANCE.eventsController.getTimeClockDispatcher().getTimeClock());
        }
        AgentLifeCycle.INSTANCE.eventsController.sendEvent(event);
    }

    public static void notifyConfigurationChange(SLAgentConfiguration configuration) {
        AgentLifeCycle.INSTANCE.eventsController.onConfigurationChanged(configuration);
    }

    public static void notifyAnonymousExecutionEvent(boolean executionFound, ExecutionDescriptor executionData) {
        AgentLifeCycle.INSTANCE.eventsController.sendAnonymousExecutionEvent(executionFound, executionData);
    }

    public static boolean notifyBuildEnd(EndBuildEventRequest endBuildRequest) {
        return AgentLifeCycle.INSTANCE.eventsController.sendBuildEndEvent(endBuildRequest);
    }

    public static void notifyMsgCollectionEvent(AgentEventCode eventCode, Collection<String> messages) {
        AgentLifeCycle.INSTANCE.eventsController.sendMsgCollectionEvent(eventCode, messages);
    }

    public static void notifyInvalidConfigurationAgentDisabledErrorEvent(Collection<String> messages) {
        AgentLifeCycle.notifyMsgCollectionEvent(AgentEventCode.INVALID_CONFIGURATION_AGENT_DISABLED, messages);
    }

    private void handleExceptionMessage(Class<?> scope, String msg, Throwable e, AgentEventsController.NotifMsgLevel notifMsgLevel) {
        this.eventsController.sendSuperUserExceptionMessage(notifMsgLevel, scope, msg, e);
    }

    @Generated
    public DefaultAgentEventsController getEventsController() {
        return this.eventsController;
    }

    @Generated
    public void setEventsController(DefaultAgentEventsController eventsController) {
        this.eventsController = eventsController;
    }

    static {
        LOG = LogFactory.getLogger(AgentLifeCycle.class);
        reportEvents = SystemPropertiesHelper.getBoolProperty("sl.agentEventsEnable", true);
    }
}

