/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import java.util.List;
import lombok.Generated;

public final class TestClassDetector {
    public static final String[] TEST_ANOTS_PKGS = new String[]{"org.testng.annotations", "org.junit"};

    public static void detect(ClassSignature classSig) {
        boolean isTestClass = false;
        if (TestClassDetector.hasTestAnotations(classSig.getAnnotations())) {
            isTestClass = true;
        } else {
            for (MethodSignature mSig : classSig.getMethods()) {
                if (!TestClassDetector.hasTestAnotations(mSig.getAnnotations())) continue;
                isTestClass = true;
                break;
            }
        }
        classSig.setTestClass(isTestClass);
    }

    private static boolean hasTestAnotations(List<AnnotationInfo> annotations) {
        if (!annotations.isEmpty()) {
            for (AnnotationInfo anot : annotations) {
                if (!TestClassDetector.isTestAnnotation(anot)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTestAnnotation(AnnotationInfo anot) {
        for (String pkg : TEST_ANOTS_PKGS) {
            if (!anot.getClassName().startsWith(pkg)) continue;
            return true;
        }
        return false;
    }

    @Generated
    private TestClassDetector() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

