/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.commons.instrument.types.LineSignature;
import io.sealights.onpremise.agents.commons.instrument.types.Probe;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodNamingHelper;
import io.sealights.onpremise.agents.commons.instrument.visitors.InsnNodeClassifier;
import io.sealights.onpremise.agents.commons.instrument.visitors.LinesAndProbesCollector;
import io.sealights.onpremise.agents.commons.instrument.visitors.MethodHashVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.MethodNode;

public class MethodInformationVisitor
extends MethodNode {
    private final String methodName;
    private final MethodVisitor methodVisitor;
    private final Collection<Probe> probes;
    private final ArrayList<LineSignature> lines;
    private ClassSignatureFactory.SignatureConfiguration signatureConfiguration;

    public MethodInformationVisitor(int access, String name, String desc, String signature, String[] exceptions, MethodVisitor methodVisitor, Collection<Probe> probes, ArrayList<LineSignature> lines, ClassSignatureFactory.SignatureConfiguration signatureConfiguration) {
        super(589824, access, name, desc, signature, exceptions);
        this.methodVisitor = methodVisitor;
        this.probes = probes;
        this.lines = lines;
        this.methodName = name;
        this.signatureConfiguration = signatureConfiguration;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        this.collectMethodInfo();
        this.accept(this.methodVisitor);
    }

    protected void collectMethodInfo() {
        MethodHashVisitor mhv = null;
        if (this.methodVisitor instanceof MethodHashVisitor) {
            mhv = (MethodHashVisitor)this.methodVisitor;
        }
        if (mhv != null) {
            mhv.getMethodSignature().setGetterOrSetter(InsnNodeClassifier.isSetterOrGetter(this.instructions, this.methodName));
        }
        if (this.shouldSkipLineAndProbesCollection(mhv)) {
            return;
        }
        this.collectLinesAndProbes();
    }

    protected void collectLinesAndProbes() {
        LinesAndProbesCollector linesAndProbesCollector = new LinesAndProbesCollector(this.methodName, this.getMethodIndex(), this.instructions);
        linesAndProbesCollector.collect();
        linesAndProbesCollector.resloveProbes();
        this.probes.addAll(linesAndProbesCollector.getProbes());
        this.addAllLines(linesAndProbesCollector.getLines());
    }

    protected int getMethodIndex() {
        MethodHashVisitor mhv = this.getMethodHashVisitor();
        if (mhv != null) {
            return mhv.getIndex();
        }
        return -1;
    }

    protected MethodHashVisitor getMethodHashVisitor() {
        if (this.methodVisitor instanceof MethodHashVisitor) {
            return (MethodHashVisitor)this.methodVisitor;
        }
        return null;
    }

    private void addAllLines(List<LineSignature> lines) {
        for (LineSignature currentLine : lines) {
            this.verifyLineAppearsOnlyOnce(currentLine);
        }
    }

    private void verifyLineAppearsOnlyOnce(LineSignature currentLine) {
        int idx = this.lines.indexOf(currentLine);
        if (idx == -1) {
            this.lines.add(currentLine);
        } else {
            LineSignature line = this.lines.get(idx);
            line.mergeHashes(currentLine);
        }
    }

    private boolean shouldSkipLineAndProbesCollection(MethodHashVisitor mhv) {
        if (!this.signatureConfiguration.isWithLineCoverage()) {
            return true;
        }
        if (!this.signatureConfiguration.isWithConstructors() && MethodNamingHelper.isCtorOrStaticCtor(this.methodName)) {
            return true;
        }
        return !this.signatureConfiguration.isWithGettersSetters() && mhv != null && mhv.getMethodSignature().isGetterOrSetter();
    }
}

