/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.commons.instrument.utils.SeaLightsTextifier;
import io.sealights.onpremise.agents.commons.instrument.visitors.AnnotationInfoNode;
import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.infra.utils.instrumentation.MethodNamingUtils;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceAnnotationVisitor;

public class MethodHashVisitor
extends MethodVisitor {
    private SeaLightsTextifier textifier;
    private String exceptions;
    private MethodSignature methodSignature;
    private List<AnnotationInfoNode> annotationNodes = new ArrayList<AnnotationInfoNode>();
    private KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata;

    public MethodHashVisitor(ClassSignatureFactory.SignatureConfiguration.SignatureType signatureType, int access, String className, String methodName, int methodIndex, String desc, String exceptions, KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata) {
        super(589824);
        this.exceptions = exceptions;
        this.textifier = new SeaLightsTextifier(signatureType);
        this.kotlinClassMetadata = kotlinClassMetadata;
        this.createMethodSignature(access, className, methodName, methodIndex, desc);
    }

    protected void createMethodSignature(int access, String className, String methodName, int methodIndex, String desc) {
        String classAndMethodName = className + "." + methodName;
        String elementId = MethodNamingUtils.getElementId(access, classAndMethodName, desc);
        String uniqueId = MethodNamingUtils.createMethodUniqueId(access, elementId, desc, this.exceptions);
        this.methodSignature = new MethodSignature(className, methodName, desc, access, elementId, uniqueId, methodIndex);
    }

    public String getElementId() {
        return this.methodSignature.getElementId();
    }

    public int getIndex() {
        return this.methodSignature.getIndex();
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Textifier printer = this.textifier.visitMethodAnnotation(desc, visible);
        AnnotationVisitor av = this.mv == null ? null : this.mv.visitAnnotation(desc, visible);
        return this.createAnnotationVisitors(desc, av, printer);
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.textifier.visitMethodAttribute(attr);
        super.visitAttribute(attr);
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        Textifier printer = this.textifier.visitAnnotationDefault();
        AnnotationVisitor av = this.mv == null ? null : this.mv.visitAnnotationDefault();
        return new TraceAnnotationVisitor(av, printer);
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        Textifier printer = this.textifier.visitParameterAnnotation(parameter, desc, visible);
        AnnotationVisitor av = this.mv == null ? null : this.mv.visitParameterAnnotation(parameter, desc, visible);
        return this.createAnnotationVisitors(desc, av, printer);
    }

    private AnnotationVisitor createAnnotationVisitors(String desc, AnnotationVisitor av, Printer printer) {
        AnnotationInfoNode node = new AnnotationInfoNode(av, desc);
        this.annotationNodes.add(node);
        return new TraceAnnotationVisitor(node, printer);
    }

    @Override
    public void visitCode() {
        this.textifier.visitCode();
        super.visitCode();
    }

    @Override
    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.textifier.visitFrame(type, nLocal, local, nStack, stack);
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    @Override
    public void visitInsn(int opcode) {
        this.textifier.visitInsn(opcode);
        super.visitInsn(opcode);
    }

    @Override
    public void visitIntInsn(int opcode, int operand) {
        this.textifier.visitIntInsn(opcode, operand);
        super.visitIntInsn(opcode, operand);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.textifier.visitVarInsn(opcode, var);
        super.visitVarInsn(opcode, var);
    }

    @Override
    public void visitTypeInsn(int opcode, String type) {
        this.textifier.visitTypeInsn(opcode, type);
        super.visitTypeInsn(opcode, type);
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.textifier.visitFieldInsn(opcode, owner, name, desc);
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        this.textifier.visitMethodInsn(opcode, owner, name, desc);
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    @Override
    public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        this.textifier.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
    }

    @Override
    public void visitJumpInsn(int opcode, Label label) {
        this.textifier.visitJumpInsn(opcode, label);
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        this.textifier.visitLabel(label);
        super.visitLabel(label);
    }

    @Override
    public void visitLdcInsn(Object cst) {
        this.textifier.visitLdcInsn(cst);
        super.visitLdcInsn(cst);
    }

    @Override
    public void visitIincInsn(int var, int increment) {
        this.textifier.visitIincInsn(var, increment);
        super.visitIincInsn(var, increment);
    }

    @Override
    public void visitTableSwitchInsn(int min2, int max, Label dflt, Label ... labels) {
        this.textifier.visitTableSwitchInsn(min2, max, dflt, labels);
        super.visitTableSwitchInsn(min2, max, dflt, labels);
    }

    @Override
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        this.textifier.visitLookupSwitchInsn(dflt, keys2, labels);
        super.visitLookupSwitchInsn(dflt, keys2, labels);
    }

    @Override
    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.textifier.visitMultiANewArrayInsn(desc, dims);
        super.visitMultiANewArrayInsn(desc, dims);
    }

    @Override
    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        this.textifier.visitTryCatchBlock(start, end, handler, type);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    @Override
    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        this.textifier.visitLocalVariable(this.methodSignature.getClassName(), this.methodSignature.getName(), this.methodSignature.getDescriptor(), name, desc, signature, start, end, index);
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    @Override
    public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        Printer printer = this.textifier.visitInsnAnnotation(typeRef, typePath, desc, visible);
        return new TraceAnnotationVisitor(printer);
    }

    @Override
    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
        this.methodSignature.applyVisitLineNumber(line);
    }

    @Override
    public void visitMaxs(int maxStack, int maxLocals) {
        this.textifier.visitMaxs(maxStack, maxLocals);
        super.visitMaxs(maxStack, maxLocals);
    }

    @Override
    public void visitEnd() {
        this.textifier.visitMethodEnd();
        this.collectAnnotations();
        this.methodSignature.calculateClassification(this.kotlinClassMetadata);
        super.visitEnd();
    }

    private void collectAnnotations() {
        for (AnnotationInfoNode node : this.annotationNodes) {
            this.methodSignature.getAnnotations().add(node.getAnnotationInfo());
        }
    }

    @Generated
    public SeaLightsTextifier getTextifier() {
        return this.textifier;
    }

    @Generated
    public String getExceptions() {
        return this.exceptions;
    }

    @Generated
    public MethodSignature getMethodSignature() {
        return this.methodSignature;
    }

    @Generated
    public List<AnnotationInfoNode> getAnnotationNodes() {
        return this.annotationNodes;
    }

    @Generated
    public KotlinMetadataExtractor.KotlinMetadata getKotlinClassMetadata() {
        return this.kotlinClassMetadata;
    }

    @Generated
    public void setTextifier(SeaLightsTextifier textifier) {
        this.textifier = textifier;
    }

    @Generated
    public void setExceptions(String exceptions) {
        this.exceptions = exceptions;
    }

    @Generated
    public void setMethodSignature(MethodSignature methodSignature) {
        this.methodSignature = methodSignature;
    }

    @Generated
    public void setAnnotationNodes(List<AnnotationInfoNode> annotationNodes) {
        this.annotationNodes = annotationNodes;
    }

    @Generated
    public void setKotlinClassMetadata(KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata) {
        this.kotlinClassMetadata = kotlinClassMetadata;
    }

    @Generated
    public String toString() {
        return "MethodHashVisitor(textifier=" + this.getTextifier() + ", exceptions=" + this.getExceptions() + ", methodSignature=" + this.getMethodSignature() + ", annotationNodes=" + this.getAnnotationNodes() + ", kotlinClassMetadata=" + this.getKotlinClassMetadata() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodHashVisitor)) {
            return false;
        }
        MethodHashVisitor other = (MethodHashVisitor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SeaLightsTextifier this$textifier = this.getTextifier();
        SeaLightsTextifier other$textifier = other.getTextifier();
        if (this$textifier == null ? other$textifier != null : !this$textifier.equals(other$textifier)) {
            return false;
        }
        String this$exceptions = this.getExceptions();
        String other$exceptions = other.getExceptions();
        if (this$exceptions == null ? other$exceptions != null : !this$exceptions.equals(other$exceptions)) {
            return false;
        }
        MethodSignature this$methodSignature = this.getMethodSignature();
        MethodSignature other$methodSignature = other.getMethodSignature();
        if (this$methodSignature == null ? other$methodSignature != null : !((Object)this$methodSignature).equals(other$methodSignature)) {
            return false;
        }
        List<AnnotationInfoNode> this$annotationNodes = this.getAnnotationNodes();
        List<AnnotationInfoNode> other$annotationNodes = other.getAnnotationNodes();
        if (this$annotationNodes == null ? other$annotationNodes != null : !((Object)this$annotationNodes).equals(other$annotationNodes)) {
            return false;
        }
        KotlinMetadataExtractor.KotlinMetadata this$kotlinClassMetadata = this.getKotlinClassMetadata();
        KotlinMetadataExtractor.KotlinMetadata other$kotlinClassMetadata = other.getKotlinClassMetadata();
        return !(this$kotlinClassMetadata == null ? other$kotlinClassMetadata != null : !this$kotlinClassMetadata.equals(other$kotlinClassMetadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MethodHashVisitor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        SeaLightsTextifier $textifier = this.getTextifier();
        result = result * 59 + ($textifier == null ? 43 : $textifier.hashCode());
        String $exceptions = this.getExceptions();
        result = result * 59 + ($exceptions == null ? 43 : $exceptions.hashCode());
        MethodSignature $methodSignature = this.getMethodSignature();
        result = result * 59 + ($methodSignature == null ? 43 : ((Object)$methodSignature).hashCode());
        List<AnnotationInfoNode> $annotationNodes = this.getAnnotationNodes();
        result = result * 59 + ($annotationNodes == null ? 43 : ((Object)$annotationNodes).hashCode());
        KotlinMetadataExtractor.KotlinMetadata $kotlinClassMetadata = this.getKotlinClassMetadata();
        result = result * 59 + ($kotlinClassMetadata == null ? 43 : $kotlinClassMetadata.hashCode());
        return result;
    }
}

