/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.commons.instrument.types.LineSignature;
import io.sealights.onpremise.agents.commons.instrument.types.Probe;
import io.sealights.onpremise.agents.commons.instrument.visitors.InsnNodeClassifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MultiANewArrayInsnNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class LinesAndProbesCollector {
    protected String methodName;
    protected int methodIndex;
    protected InsnList methodInstructions;
    protected Map<Label, Integer> lineNumbers = new HashMap<Label, Integer>();
    protected Map<Label, Integer> hashScope = new HashMap<Label, Integer>();
    protected List<LineSignature> lines = new ArrayList<LineSignature>();
    protected List<Probe> probes = new ArrayList<Probe>();
    protected List<String> hashes = new ArrayList<String>();
    protected Set<Label> visited = new HashSet<Label>();
    protected Map<Label, LabelNode> uninitialized = new HashMap<Label, LabelNode>();
    protected Map<Label, Integer> explicitLineNumbers = new HashMap<Label, Integer>();
    protected Map<AbstractInsnNode, Label> startLabels = new HashMap<AbstractInsnNode, Label>();
    Map<Label, Integer> labelToOriginalPosition = new HashMap<Label, Integer>();

    public LinesAndProbesCollector(String methodName, int methodIndex, InsnList methodInstructions) {
        this.methodName = methodName;
        this.methodIndex = methodIndex;
        this.methodInstructions = methodInstructions;
    }

    public void collect() {
        this.collectLinesHashes();
        this.classifyProbesAndCollectInsnHashes();
        this.repairFrames();
    }

    public void resloveProbes() {
        for (Probe probe : this.probes) {
            probe.resolve(this.lineNumbers, this.hashScope, this.hashes);
        }
    }

    private void collectLinesHashes() {
        LineSignature currentLine = new LineSignature(-1, this.methodName, this.methodIndex);
        block6: for (int index = 0; index < this.methodInstructions.size(); ++index) {
            AbstractInsnNode instruction = this.methodInstructions.get(index);
            switch (instruction.getType()) {
                case 15: {
                    LineNumberNode lineNumberNode = (LineNumberNode)instruction;
                    this.explicitLineNumbers.put(lineNumberNode.start.getLabel(), lineNumberNode.line);
                    currentLine = new LineSignature(lineNumberNode.line, this.methodName, this.methodIndex);
                    if (this.lines.contains(currentLine)) continue block6;
                    this.lines.add(currentLine);
                    continue block6;
                }
                case 7: 
                case 11: 
                case 12: {
                    this.addInstructionHash(instruction, currentLine.getHash());
                    Label label = new Label();
                    this.labelToOriginalPosition.put(label, this.labelToOriginalPosition.size());
                    this.methodInstructions.insertBefore(instruction, new LabelNode(label));
                    this.startLabels.put(instruction, label);
                    ++index;
                    continue block6;
                }
                case 8: {
                    this.labelToOriginalPosition.put(((LabelNode)instruction).getLabel(), this.labelToOriginalPosition.size());
                    continue block6;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 13: {
                    this.addInstructionHash(instruction, currentLine.getHash());
                }
            }
        }
    }

    protected void classifyProbesAndCollectInsnHashes() {
        int lastLine = -1;
        block8: for (int index = 0; index < this.methodInstructions.size(); ++index) {
            AbstractInsnNode instruction = this.methodInstructions.get(index);
            switch (instruction.getType()) {
                case 8: {
                    LabelNode labelNode = (LabelNode)instruction;
                    HashSet<Label> labels = new HashSet<Label>(Collections.singleton(labelNode.getLabel()));
                    Integer value = this.explicitLineNumbers.get(labelNode.getLabel());
                    if (value != null) {
                        lastLine = value;
                        while (InsnNodeClassifier.isMetaNode(instruction.getNext())) {
                            if ((instruction = instruction.getNext()) instanceof LabelNode) {
                                LabelNode nestedLabelNode = (LabelNode)instruction;
                                value = this.explicitLineNumbers.get(nestedLabelNode.getLabel());
                                if (value != null) {
                                    lastLine = value;
                                }
                                labels.add(nestedLabelNode.getLabel());
                            }
                            ++index;
                        }
                    }
                    for (Label label : labels) {
                        this.lineNumbers.put(label, lastLine);
                        this.hashScope.put(label, this.hashes.size());
                        this.visited.add(label);
                    }
                    continue block8;
                }
                case 7: {
                    JumpInsnNode jumpNode = (JumpInsnNode)instruction;
                    this.probes.add(new Probe(this.visited.contains(jumpNode.label.getLabel()), this.startLabels.get(instruction), jumpNode.label.getLabel()));
                    continue block8;
                }
                case 12: {
                    Label target;
                    LookupSwitchInsnNode lookupSwitchNode = (LookupSwitchInsnNode)instruction;
                    Label previous = this.startLabels.get(instruction);
                    for (LabelNode node : lookupSwitchNode.labels) {
                        target = node.getLabel();
                        this.probes.add(new Probe(this.labelToOriginalPosition.get(previous) > this.labelToOriginalPosition.get(target), previous, target));
                        previous = target;
                    }
                    Object target2 = lookupSwitchNode.dflt.getLabel();
                    this.probes.add(new Probe(this.labelToOriginalPosition.get(previous) > this.labelToOriginalPosition.get(target2), previous, (Label)target2));
                    continue block8;
                }
                case 11: {
                    Label target;
                    TableSwitchInsnNode tableSwitchNode = (TableSwitchInsnNode)instruction;
                    Label previous = this.startLabels.get(instruction);
                    for (LabelNode node : tableSwitchNode.labels) {
                        target = node.getLabel();
                        this.probes.add(new Probe(this.labelToOriginalPosition.get(previous) > this.labelToOriginalPosition.get(target), previous, target));
                        previous = target;
                    }
                    Object target2 = tableSwitchNode.dflt.getLabel();
                    this.probes.add(new Probe(this.labelToOriginalPosition.get(previous) > this.labelToOriginalPosition.get(target2), previous, (Label)target2));
                    continue block8;
                }
                case 3: {
                    this.addInstructionHash(instruction, this.hashes);
                    LabelNode prior = new LabelNode(new Label());
                    this.methodInstructions.insertBefore(instruction, prior);
                    for (Label previous : this.visited) {
                        if (this.uninitialized.containsKey(previous)) continue;
                        this.uninitialized.put(previous, prior);
                    }
                    ++index;
                    continue block8;
                }
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 13: {
                    this.addInstructionHash(instruction, this.hashes);
                }
            }
        }
    }

    protected void repairFrames() {
        for (int index = 0; index < this.methodInstructions.size(); ++index) {
            LabelNode label;
            Object frame;
            int offset;
            AbstractInsnNode instruction = this.methodInstructions.get(index);
            if (instruction.getType() != 14) continue;
            FrameNode frameNode = (FrameNode)instruction;
            if (frameNode.local != null) {
                for (offset = 0; offset < frameNode.local.size(); ++offset) {
                    frame = frameNode.local.get(offset);
                    if (!(frame instanceof LabelNode) || (label = this.uninitialized.get(((LabelNode)frame).getLabel())) == null) continue;
                    frameNode.local.set(offset, label);
                }
            }
            if (frameNode.stack == null) continue;
            for (offset = 0; offset < frameNode.stack.size(); ++offset) {
                frame = frameNode.stack.get(offset);
                if (!(frame instanceof LabelNode) || (label = this.uninitialized.get(((LabelNode)frame).getLabel())) == null) continue;
                frameNode.stack.set(offset, label);
            }
        }
    }

    protected void addInstructionHash(AbstractInsnNode instruction, List<String> currentHash) {
        switch (instruction.getType()) {
            case 3: {
                TypeInsnNode typeNode = (TypeInsnNode)instruction;
                currentHash.add(typeNode.getOpcode() + "," + typeNode.desc);
                break;
            }
            case 9: {
                LdcInsnNode ldcNode = (LdcInsnNode)instruction;
                currentHash.add(ldcNode.getOpcode() + "," + ldcNode.cst);
                break;
            }
            case 1: {
                IntInsnNode intNode = (IntInsnNode)instruction;
                currentHash.add(intNode.getOpcode() + "," + intNode.operand);
                break;
            }
            case 0: {
                InsnNode node = (InsnNode)instruction;
                currentHash.add(String.valueOf(node.getOpcode()));
                break;
            }
            case 5: {
                MethodInsnNode methodNode = (MethodInsnNode)instruction;
                currentHash.add(methodNode.getOpcode() + "," + methodNode.owner + methodNode.name + methodNode.desc);
                break;
            }
            case 4: {
                FieldInsnNode fieldNode = (FieldInsnNode)instruction;
                currentHash.add(fieldNode.getOpcode() + "," + fieldNode.owner + fieldNode.name + fieldNode.desc);
                break;
            }
            case 2: {
                VarInsnNode varNode = (VarInsnNode)instruction;
                currentHash.add(varNode.getOpcode() + "," + varNode.var);
                break;
            }
            case 13: {
                MultiANewArrayInsnNode multiANewArrayNode = (MultiANewArrayInsnNode)instruction;
                currentHash.add(multiANewArrayNode.getOpcode() + "," + multiANewArrayNode.desc + multiANewArrayNode.dims);
                break;
            }
            case 10: {
                IincInsnNode iincNode = (IincInsnNode)instruction;
                currentHash.add(iincNode.getOpcode() + "," + iincNode.var + "," + iincNode.incr);
                break;
            }
            case 6: {
                InvokeDynamicInsnNode invokeDynamicNode = (InvokeDynamicInsnNode)instruction;
                currentHash.add(invokeDynamicNode.getOpcode() + "," + invokeDynamicNode.name + "," + invokeDynamicNode.desc + "," + invokeDynamicNode.bsm.getName() + "," + invokeDynamicNode.bsm.getTag() + "," + invokeDynamicNode.bsm.getDesc() + "," + invokeDynamicNode.bsm.getOwner());
            }
        }
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Generated
    public int getMethodIndex() {
        return this.methodIndex;
    }

    @Generated
    public InsnList getMethodInstructions() {
        return this.methodInstructions;
    }

    @Generated
    public Map<Label, Integer> getLineNumbers() {
        return this.lineNumbers;
    }

    @Generated
    public Map<Label, Integer> getHashScope() {
        return this.hashScope;
    }

    @Generated
    public List<LineSignature> getLines() {
        return this.lines;
    }

    @Generated
    public List<Probe> getProbes() {
        return this.probes;
    }

    @Generated
    public List<String> getHashes() {
        return this.hashes;
    }

    @Generated
    public Set<Label> getVisited() {
        return this.visited;
    }

    @Generated
    public Map<Label, LabelNode> getUninitialized() {
        return this.uninitialized;
    }

    @Generated
    public Map<Label, Integer> getExplicitLineNumbers() {
        return this.explicitLineNumbers;
    }

    @Generated
    public Map<AbstractInsnNode, Label> getStartLabels() {
        return this.startLabels;
    }

    @Generated
    public Map<Label, Integer> getLabelToOriginalPosition() {
        return this.labelToOriginalPosition;
    }

    @Generated
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Generated
    public void setMethodIndex(int methodIndex) {
        this.methodIndex = methodIndex;
    }

    @Generated
    public void setMethodInstructions(InsnList methodInstructions) {
        this.methodInstructions = methodInstructions;
    }

    @Generated
    public void setLineNumbers(Map<Label, Integer> lineNumbers) {
        this.lineNumbers = lineNumbers;
    }

    @Generated
    public void setHashScope(Map<Label, Integer> hashScope) {
        this.hashScope = hashScope;
    }

    @Generated
    public void setLines(List<LineSignature> lines) {
        this.lines = lines;
    }

    @Generated
    public void setProbes(List<Probe> probes) {
        this.probes = probes;
    }

    @Generated
    public void setHashes(List<String> hashes) {
        this.hashes = hashes;
    }

    @Generated
    public void setVisited(Set<Label> visited) {
        this.visited = visited;
    }

    @Generated
    public void setUninitialized(Map<Label, LabelNode> uninitialized) {
        this.uninitialized = uninitialized;
    }

    @Generated
    public void setExplicitLineNumbers(Map<Label, Integer> explicitLineNumbers) {
        this.explicitLineNumbers = explicitLineNumbers;
    }

    @Generated
    public void setStartLabels(Map<AbstractInsnNode, Label> startLabels) {
        this.startLabels = startLabels;
    }

    @Generated
    public void setLabelToOriginalPosition(Map<Label, Integer> labelToOriginalPosition) {
        this.labelToOriginalPosition = labelToOriginalPosition;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinesAndProbesCollector)) {
            return false;
        }
        LinesAndProbesCollector other = (LinesAndProbesCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        if (this.getMethodIndex() != other.getMethodIndex()) {
            return false;
        }
        InsnList this$methodInstructions = this.getMethodInstructions();
        InsnList other$methodInstructions = other.getMethodInstructions();
        if (this$methodInstructions == null ? other$methodInstructions != null : !this$methodInstructions.equals(other$methodInstructions)) {
            return false;
        }
        Map<Label, Integer> this$lineNumbers = this.getLineNumbers();
        Map<Label, Integer> other$lineNumbers = other.getLineNumbers();
        if (this$lineNumbers == null ? other$lineNumbers != null : !((Object)this$lineNumbers).equals(other$lineNumbers)) {
            return false;
        }
        Map<Label, Integer> this$hashScope = this.getHashScope();
        Map<Label, Integer> other$hashScope = other.getHashScope();
        if (this$hashScope == null ? other$hashScope != null : !((Object)this$hashScope).equals(other$hashScope)) {
            return false;
        }
        List<LineSignature> this$lines = this.getLines();
        List<LineSignature> other$lines = other.getLines();
        if (this$lines == null ? other$lines != null : !((Object)this$lines).equals(other$lines)) {
            return false;
        }
        List<Probe> this$probes = this.getProbes();
        List<Probe> other$probes = other.getProbes();
        if (this$probes == null ? other$probes != null : !((Object)this$probes).equals(other$probes)) {
            return false;
        }
        List<String> this$hashes = this.getHashes();
        List<String> other$hashes = other.getHashes();
        if (this$hashes == null ? other$hashes != null : !((Object)this$hashes).equals(other$hashes)) {
            return false;
        }
        Set<Label> this$visited = this.getVisited();
        Set<Label> other$visited = other.getVisited();
        if (this$visited == null ? other$visited != null : !((Object)this$visited).equals(other$visited)) {
            return false;
        }
        Map<Label, LabelNode> this$uninitialized = this.getUninitialized();
        Map<Label, LabelNode> other$uninitialized = other.getUninitialized();
        if (this$uninitialized == null ? other$uninitialized != null : !((Object)this$uninitialized).equals(other$uninitialized)) {
            return false;
        }
        Map<Label, Integer> this$explicitLineNumbers = this.getExplicitLineNumbers();
        Map<Label, Integer> other$explicitLineNumbers = other.getExplicitLineNumbers();
        if (this$explicitLineNumbers == null ? other$explicitLineNumbers != null : !((Object)this$explicitLineNumbers).equals(other$explicitLineNumbers)) {
            return false;
        }
        Map<AbstractInsnNode, Label> this$startLabels = this.getStartLabels();
        Map<AbstractInsnNode, Label> other$startLabels = other.getStartLabels();
        if (this$startLabels == null ? other$startLabels != null : !((Object)this$startLabels).equals(other$startLabels)) {
            return false;
        }
        Map<Label, Integer> this$labelToOriginalPosition = this.getLabelToOriginalPosition();
        Map<Label, Integer> other$labelToOriginalPosition = other.getLabelToOriginalPosition();
        return !(this$labelToOriginalPosition == null ? other$labelToOriginalPosition != null : !((Object)this$labelToOriginalPosition).equals(other$labelToOriginalPosition));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LinesAndProbesCollector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        result = result * 59 + this.getMethodIndex();
        InsnList $methodInstructions = this.getMethodInstructions();
        result = result * 59 + ($methodInstructions == null ? 43 : $methodInstructions.hashCode());
        Map<Label, Integer> $lineNumbers = this.getLineNumbers();
        result = result * 59 + ($lineNumbers == null ? 43 : ((Object)$lineNumbers).hashCode());
        Map<Label, Integer> $hashScope = this.getHashScope();
        result = result * 59 + ($hashScope == null ? 43 : ((Object)$hashScope).hashCode());
        List<LineSignature> $lines = this.getLines();
        result = result * 59 + ($lines == null ? 43 : ((Object)$lines).hashCode());
        List<Probe> $probes = this.getProbes();
        result = result * 59 + ($probes == null ? 43 : ((Object)$probes).hashCode());
        List<String> $hashes = this.getHashes();
        result = result * 59 + ($hashes == null ? 43 : ((Object)$hashes).hashCode());
        Set<Label> $visited = this.getVisited();
        result = result * 59 + ($visited == null ? 43 : ((Object)$visited).hashCode());
        Map<Label, LabelNode> $uninitialized = this.getUninitialized();
        result = result * 59 + ($uninitialized == null ? 43 : ((Object)$uninitialized).hashCode());
        Map<Label, Integer> $explicitLineNumbers = this.getExplicitLineNumbers();
        result = result * 59 + ($explicitLineNumbers == null ? 43 : ((Object)$explicitLineNumbers).hashCode());
        Map<AbstractInsnNode, Label> $startLabels = this.getStartLabels();
        result = result * 59 + ($startLabels == null ? 43 : ((Object)$startLabels).hashCode());
        Map<Label, Integer> $labelToOriginalPosition = this.getLabelToOriginalPosition();
        result = result * 59 + ($labelToOriginalPosition == null ? 43 : ((Object)$labelToOriginalPosition).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LinesAndProbesCollector(methodName=" + this.getMethodName() + ", methodIndex=" + this.getMethodIndex() + ", methodInstructions=" + this.getMethodInstructions() + ", lineNumbers=" + this.getLineNumbers() + ", hashScope=" + this.getHashScope() + ", lines=" + this.getLines() + ", probes=" + this.getProbes() + ", hashes=" + this.getHashes() + ", visited=" + this.getVisited() + ", uninitialized=" + this.getUninitialized() + ", explicitLineNumbers=" + this.getExplicitLineNumbers() + ", startLabels=" + this.getStartLabels() + ", labelToOriginalPosition=" + this.getLabelToOriginalPosition() + ")";
    }
}

