/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.Collections;
import java.util.List;
import kotlinx.metadata.KmConstructor;
import kotlinx.metadata.KmFunction;
import kotlinx.metadata.KmProperty;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;
import org.slf4j.Logger;

public class KotlinMetadataExtractor {
    private static final int K_INDEX = 5;
    private static final int MV_INDEX = 1;
    private static final int BV_INDEX = 3;
    private static final int D1_INDEX = 7;
    private static final int D2_INDEX = 9;
    private static final KotlinMetadataExtractor INSTANCE = new KotlinMetadataExtractor();

    public static KotlinMetadata extractMetadata(String className, AnnotationInfo annotationInfo) {
        return INSTANCE.extract(className, annotationInfo);
    }

    public KotlinMetadata extract(String className, AnnotationInfo annotationInfo) {
        try {
            List<Object> values2 = annotationInfo.getKotlinMetadataRawValues();
            int kind = (Integer)values2.get(5);
            int[] metadataVersion = this.listToIntArray((List)values2.get(1));
            int[] bytecodeVersion = this.listToIntArray((List)values2.get(3));
            String[] data1 = this.getStringArrayFromAnnotationValue(values2, 7);
            String[] data2 = this.getStringArrayFromAnnotationValue(values2, 9);
            KotlinClassHeader kotlinClassHeader = new KotlinClassHeader(kind, metadataVersion, bytecodeVersion, data1, data2, null, null, null);
            return new KotlinMetadata(className, KotlinClassMetadata.read(kotlinClassHeader));
        }
        catch (Exception e) {
            return null;
        }
    }

    private String[] getStringArrayFromAnnotationValue(List<Object> vals, int annotationValueIndex) {
        if (annotationValueIndex > vals.size() - 1) {
            return new String[0];
        }
        List list = (List)vals.get(annotationValueIndex);
        if (list == null) {
            return new String[0];
        }
        return list.toArray(new String[0]);
    }

    private int[] listToIntArray(List list) {
        if (list == null) {
            return new int[0];
        }
        Object[] objects = list.toArray();
        int[] ints = new int[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ints[i] = (Integer)objects[i];
        }
        return ints;
    }

    public static class KotlinMetadata {
        private static Logger LOG = LogFactory.getLogger(KotlinMetadata.class);
        private final String className;
        private final KotlinClassMetadata rawMetadata;
        private List<KmProperty> properties;
        private List<KmFunction> functions;
        private List<KmConstructor> constructors;

        public KotlinMetadata(String className, KotlinClassMetadata rawMetadata) {
            this.className = className;
            this.rawMetadata = rawMetadata;
        }

        public boolean isKotlinSyntheticClass() {
            return this.rawMetadata.getHeader().getKind() == KotlinClassKind.SYNTHETIC_CLASS.getCode();
        }

        public List<KmProperty> getProperties() {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = this.resolveProperties();
            return this.properties;
        }

        public List<KmFunction> getFunctions() {
            if (this.functions != null) {
                return this.functions;
            }
            this.functions = this.resolveFunctions();
            return this.functions;
        }

        public List<KmConstructor> getConstructors() {
            if (this.constructors != null) {
                return this.constructors;
            }
            this.constructors = this.resolveConstructors();
            return this.constructors;
        }

        private List<KmProperty> resolveProperties() {
            KotlinClassKind classKind = KotlinClassKind.of(this.rawMetadata.getHeader().getKind());
            if (classKind == null) {
                return Collections.emptyList();
            }
            try {
                switch (classKind) {
                    case CLASS: {
                        return ((KotlinClassMetadata.Class)this.rawMetadata).toKmClass().getProperties();
                    }
                    case FILE_FACADE: {
                        return ((KotlinClassMetadata.FileFacade)this.rawMetadata).toKmPackage().getProperties();
                    }
                    case MULTIFILE_CLASS: {
                        return ((KotlinClassMetadata.MultiFileClassPart)this.rawMetadata).toKmPackage().getProperties();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error while extracting properties metadata of Kotlin class: {}", (Object)this.className);
            }
            return Collections.emptyList();
        }

        private List<KmFunction> resolveFunctions() {
            KotlinClassKind classKind = KotlinClassKind.of(this.rawMetadata.getHeader().getKind());
            if (classKind == null) {
                return Collections.emptyList();
            }
            try {
                switch (classKind) {
                    case CLASS: {
                        return ((KotlinClassMetadata.Class)this.rawMetadata).toKmClass().getFunctions();
                    }
                    case FILE_FACADE: {
                        return ((KotlinClassMetadata.FileFacade)this.rawMetadata).toKmPackage().getFunctions();
                    }
                    case MULTIFILE_CLASS: {
                        return ((KotlinClassMetadata.MultiFileClassPart)this.rawMetadata).toKmPackage().getFunctions();
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error while extracting functions metadata of Kotlin class: {}", (Object)this.className);
            }
            return Collections.emptyList();
        }

        private List<KmConstructor> resolveConstructors() {
            try {
                if (this.rawMetadata.getHeader().getKind() == KotlinClassKind.CLASS.getCode()) {
                    return ((KotlinClassMetadata.Class)this.rawMetadata).toKmClass().getConstructors();
                }
            }
            catch (Exception e) {
                LOG.error("Error while extracting constructors metadata of Kotlin class: {}", (Object)this.className);
            }
            return Collections.emptyList();
        }
    }

    public static enum KotlinClassKind {
        CLASS(1),
        FILE_FACADE(2),
        SYNTHETIC_CLASS(3),
        MULTIFILE_CLASS(5);

        private final int code;

        private KotlinClassKind(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static KotlinClassKind of(int code) {
            for (KotlinClassKind value : KotlinClassKind.values()) {
                if (value.code != code) continue;
                return value;
            }
            return null;
        }
    }
}

