/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import java.util.ArrayList;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InsnNodeClassifier {
    public static boolean isSetterOrGetter(InsnList instructions, String methodName) {
        if (instructions.size() <= 0) {
            return false;
        }
        AbstractInsnNode firstInstruction = instructions.get(0);
        if ((methodName.startsWith("get") || methodName.startsWith("is")) && InsnNodeClassifier.isGetter(firstInstruction)) {
            return true;
        }
        return methodName.startsWith("set") && InsnNodeClassifier.isSetter(firstInstruction);
    }

    public static boolean isMetaNode(AbstractInsnNode node) {
        return node instanceof LineNumberNode || node instanceof LabelNode || node instanceof FrameNode;
    }

    private static boolean isGetter(AbstractInsnNode firstInstruction) {
        while (firstInstruction != null && InsnNodeClassifier.isMetaNode(firstInstruction)) {
            firstInstruction = firstInstruction.getNext();
        }
        if (firstInstruction == null) {
            return false;
        }
        AbstractInsnNode secondInstruction = firstInstruction.getNext();
        if (secondInstruction == null) {
            return false;
        }
        AbstractInsnNode lastInstruction = secondInstruction.getNext();
        if (lastInstruction == null) {
            return false;
        }
        int secondOpcode = secondInstruction.getOpcode();
        int lastOpcode = lastInstruction.getOpcode();
        boolean noOtherInstructions = !InsnNodeClassifier.hasOtherCodeNodes(lastInstruction.getNext());
        boolean isGetter = firstInstruction instanceof VarInsnNode && ((VarInsnNode)firstInstruction).var == 0 && secondOpcode == 180 && lastOpcode >= 172 && lastOpcode <= 177 && noOtherInstructions;
        return isGetter;
    }

    private static boolean isSetter(AbstractInsnNode instruction) {
        if (InsnNodeClassifier.isSetterInternal(instruction)) {
            return true;
        }
        return InsnNodeClassifier.isKotlinObjectSetter(instruction);
    }

    private static boolean isSetterInternal(AbstractInsnNode instruction) {
        if (instruction == null) {
            return false;
        }
        int NUMBER_OF_INSTRUCTIONS_IN_PATTERN = 4;
        ArrayList<AbstractInsnNode> instructions = new ArrayList<AbstractInsnNode>();
        while (instruction != null && instructions.size() <= NUMBER_OF_INSTRUCTIONS_IN_PATTERN) {
            while (instruction != null && InsnNodeClassifier.isMetaNode(instruction)) {
                instruction = instruction.getNext();
            }
            if (instruction == null) continue;
            instructions.add(instruction);
            instruction = instruction.getNext();
        }
        if (instructions.size() < NUMBER_OF_INSTRUCTIONS_IN_PATTERN) {
            return false;
        }
        AbstractInsnNode lastInstruction = (AbstractInsnNode)instructions.get(NUMBER_OF_INSTRUCTIONS_IN_PATTERN - 1);
        int lastOpcode = lastInstruction.getOpcode();
        boolean noOtherInstructions = !InsnNodeClassifier.hasOtherCodeNodes(lastInstruction.getNext());
        boolean isSetter = instructions.get(0) instanceof VarInsnNode && ((VarInsnNode)instructions.get((int)0)).var == 0 && ((AbstractInsnNode)instructions.get(1)).getOpcode() <= 25 && ((AbstractInsnNode)instructions.get(1)).getOpcode() >= 21 && ((AbstractInsnNode)instructions.get(2)).getOpcode() == 181 && lastOpcode == 177 && noOtherInstructions;
        return isSetter;
    }

    private static boolean hasOtherCodeNodes(AbstractInsnNode instruction) {
        while (instruction != null) {
            if (!InsnNodeClassifier.isMetaNode(instruction)) {
                return true;
            }
            instruction = instruction.getNext();
        }
        return false;
    }

    private static boolean isKotlinObjectSetter(AbstractInsnNode instruction) {
        if (instruction == null) {
            return false;
        }
        int NUMBER_OF_INSTRUCTIONS_IN_PATTERN = 7;
        ArrayList<AbstractInsnNode> instructions = new ArrayList<AbstractInsnNode>();
        while (instruction != null && instructions.size() <= NUMBER_OF_INSTRUCTIONS_IN_PATTERN) {
            while (instruction != null && InsnNodeClassifier.isMetaNode(instruction)) {
                instruction = instruction.getNext();
            }
            if (instruction == null) continue;
            instructions.add(instruction);
            instruction = instruction.getNext();
        }
        if (instructions.size() < NUMBER_OF_INSTRUCTIONS_IN_PATTERN) {
            return false;
        }
        AbstractInsnNode lastInstruction = (AbstractInsnNode)instructions.get(NUMBER_OF_INSTRUCTIONS_IN_PATTERN - 1);
        int lastOpcode = lastInstruction.getOpcode();
        boolean noOtherInstructions = !InsnNodeClassifier.hasOtherCodeNodes(lastInstruction.getNext());
        boolean isSetter = instructions.get(0) instanceof VarInsnNode && ((VarInsnNode)instructions.get((int)0)).var == 1 && ((AbstractInsnNode)instructions.get(1)).getOpcode() == 18 && ((AbstractInsnNode)instructions.get(2)).getOpcode() == 184 && instructions.get(3) instanceof VarInsnNode && ((VarInsnNode)instructions.get((int)3)).var == 0 && instructions.get(4) instanceof VarInsnNode && ((VarInsnNode)instructions.get((int)4)).var == 1 && ((AbstractInsnNode)instructions.get(5)).getOpcode() == 181 && lastOpcode == 177 && noOtherInstructions;
        return isSetter;
    }
}

