/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;

public final class ClassVisitorHelper {
    public static char DOT = (char)46;
    public static char SLASH = (char)47;

    public static boolean isClassGeneratedByJavaAssist(String className) {
        return className.contains("_$$_jvst") || className.contains("_javassist_");
    }

    public static boolean isLambdaMethod(String methodName) {
        return methodName.startsWith("lambda$");
    }

    public static boolean isSyntheticMethod(int methodAccess) {
        return (methodAccess & 0x1000) != 0;
    }

    public static boolean isAbstractMethod(int methodAccess) {
        return (methodAccess & 0x400) != 0;
    }

    public static boolean skipMethodInstrumentation(String className, int methodAccess, String methodName) {
        return ClassVisitorHelper.isSyntheticMethod(methodAccess) && !ClassVisitorHelper.isLambdaMethod(methodName) || ClassVisitorHelper.isAbstractMethod(methodAccess) || ClassVisitorHelper.isClassGeneratedByJavaAssist(className);
    }

    public static String slashToDot(String slashedClassName) {
        return slashedClassName.replace(SLASH, DOT);
    }

    public static String dotToSlash(String dotClassName) {
        return dotClassName.replace(DOT, SLASH);
    }

    public static String resolveBinaryPackageName(String slashedClassName) {
        if (StringUtils.isNullOrEmpty(slashedClassName)) {
            return "";
        }
        String packageName = "";
        int simpleClassNameIndex = slashedClassName.lastIndexOf(SLASH);
        if (simpleClassNameIndex != -1) {
            packageName = slashedClassName.substring(0, simpleClassNameIndex);
        }
        return packageName;
    }

    public static String resolveClassSimpleName(String dotClassName) {
        if (StringUtils.isNullOrEmpty(dotClassName)) {
            return "";
        }
        return dotClassName.substring(Math.max(dotClassName.lastIndexOf(DOT), dotClassName.lastIndexOf(36)) + 1);
    }

    @Generated
    private ClassVisitorHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

