/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.visitors;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.types.LineSignature;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.types.Probe;
import io.sealights.onpremise.agents.commons.instrument.types.SourceLanguage;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.commons.instrument.utils.HashingUtils;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodHashingStringNotifier;
import io.sealights.onpremise.agents.commons.instrument.utils.SeaLightsTextifier;
import io.sealights.onpremise.agents.commons.instrument.visitors.AnnotationInfoNode;
import io.sealights.onpremise.agents.commons.instrument.visitors.ClassVisitorHelper;
import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.commons.instrument.visitors.MethodHashVisitor;
import io.sealights.onpremise.agents.commons.instrument.visitors.MethodInformationVisitor;
import io.sealights.onpremise.agents.commons.instrument.visitors.TestClassDetector;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureExcludeFilter;
import io.sealights.onpremise.agents.instrument.filters.SkipMethodVisitFilters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceFieldVisitor;
import org.slf4j.Logger;

public class ClassHashVisitor
extends ClassVisitor {
    private static Logger LOG = LogFactory.getLogger(ClassHashVisitor.class);
    private static final String ASPECTJ_PACKAGE_PREFIX = "org.aspectj";
    private ClassSignature classSignature;
    private HashMap<String, MethodHashVisitor> methodVisitors = new HashMap();
    private List<AnnotationInfoNode> annotationNodes = new ArrayList<AnnotationInfoNode>();
    private Printer textifier;
    private Printer constructorsTextifier;
    private ClassSignatureFactory.SignatureConfiguration signatureConfiguration;
    private final ArrayList<Probe> probes = new ArrayList();
    private final ArrayList<LineSignature> lines = new ArrayList();
    private boolean annotationsCollected = false;
    private KotlinMetadataExtractor.KotlinMetadata kotlinMetadata;
    private SkipMethodVisitFilters.SkipMethodVisitFilter internalMethodExcludeFilter;
    private MethodSignatureExcludeFilter methodExcludeFilter;
    private MethodSignatureExcludeFilter.CustomExcludeMethodFilter customExcludeMethodFilter;
    private final HashingUtils hashingUtils;
    private boolean aspectJAttributesPresent;

    public ClassHashVisitor(ClassSignatureFactory.SignatureConfiguration signatureConfiguration) {
        this(signatureConfiguration, null, new HashingUtils());
    }

    public ClassHashVisitor(ClassSignatureFactory.SignatureConfiguration signatureConfiguration, MethodSignatureExcludeFilter.CustomExcludeMethodFilter customExcludeMethodFilter, HashingUtils hashingUtils) {
        super(589824);
        this.signatureConfiguration = signatureConfiguration;
        this.textifier = new SeaLightsTextifier(signatureConfiguration.getType());
        this.constructorsTextifier = new SeaLightsTextifier(signatureConfiguration.getType());
        this.customExcludeMethodFilter = customExcludeMethodFilter;
        this.hashingUtils = hashingUtils;
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classSignature = new ClassSignature(access, name, superName, interfaces);
        this.textifier.visit(version, access, name, signature, superName, interfaces);
        this.constructorsTextifier.visit(version, access, name, signature, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public void visitSource(String sourceFile, String debug) {
        this.classSignature.setSourceFile(sourceFile);
        this.textifier.visitSource(sourceFile, debug);
        super.visitSource(sourceFile, debug);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        this.textifier.visitOuterClass(owner, name, desc);
        super.visitOuterClass(owner, name, desc);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Printer printer = this.textifier.visitClassAnnotation(desc, visible);
        printer = this.constructorsTextifier.visitClassAnnotation(desc, visible);
        AnnotationInfoNode node = new AnnotationInfoNode(desc);
        this.annotationNodes.add(node);
        TraceAnnotationVisitor av = new TraceAnnotationVisitor(node, printer);
        return av;
    }

    @Override
    public void visitAttribute(Attribute attr) {
        this.handleAspectJAttributes(attr);
        this.textifier.visitClassAttribute(attr);
        super.visitAttribute(attr);
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.textifier.visitInnerClass(name, outerName, innerName, access);
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Printer printer = this.textifier.visitField(access, name, desc, signature, value);
        printer = this.constructorsTextifier.visitField(access, name, desc, signature, value);
        return new TraceFieldVisitor(printer);
    }

    public ArrayList<Probe> getProbes() {
        return this.probes;
    }

    public ArrayList<LineSignature> getLines() {
        return this.lines;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.initClassMetadata();
        if (this.internalMethodExcludeFilter.match(this.classSignature.getClassName(), access, name)) {
            return null;
        }
        this.textifier.visitMethod(access, name, desc, signature, exceptions);
        String className = ClassVisitorHelper.slashToDot(this.classSignature.getClassName());
        MethodHashVisitor mhv = new MethodHashVisitor(this.signatureConfiguration.getType(), access, className, name, this.methodVisitors.size(), desc, Arrays.toString(exceptions), this.kotlinMetadata);
        this.methodVisitors.put(mhv.getElementId(), mhv);
        if (this.shouldCollectMethodInformation()) {
            MethodInformationVisitor methodInformationVisitor = new MethodInformationVisitor(access, name, desc, signature, exceptions, mhv, this.probes, this.lines, this.signatureConfiguration);
            return methodInformationVisitor;
        }
        return mhv;
    }

    private boolean shouldCollectMethodInformation() {
        return this.signatureConfiguration.isWithLineCoverage() || this.signatureConfiguration.isWithGettersSetters();
    }

    @Override
    public void visitEnd() {
        this.textifier.visitClassEnd();
        String ctorAsString = null;
        if (this.signatureConfiguration.isScanSignature()) {
            this.setClassHash();
            ctorAsString = this.hashingUtils.buildHashString(this.constructorsTextifier);
        }
        for (MethodHashVisitor mhv : this.methodVisitors.values()) {
            MethodSignature mSig = mhv.getMethodSignature();
            if (this.methodExcludeFilter.match(mSig)) {
                LOG.debug("skipped '{}.{}'", (Object)mSig.getClassName(), (Object)mSig.getName());
                continue;
            }
            if (this.signatureConfiguration.isScanSignature()) {
                this.setMethodHash(mhv, ctorAsString);
            }
            this.classSignature.addMethod(mSig);
        }
        this.classSignature.setLines(this.lines);
        LOG.trace("Collected: \nclass: '{}'\nmethods:{}lines:{}", this.classSignature.getClassName(), LogLevelToStringFormatter.toString(Level.TRACE, this.classSignature.getMethods()), LogLevelToStringFormatter.toString(Level.TRACE, this.classSignature.getLines()));
        this.methodVisitors = null;
        this.classSignature.updateRelativePath();
        TestClassDetector.detect(this.classSignature);
        super.visitEnd();
    }

    private void setClassHash() {
        String classAsString = this.hashingUtils.buildHashString(this.textifier);
        LOG.trace("########################### Class: " + this.classSignature.getClassName() + ")");
        this.classSignature.setHash(this.hashingUtils.toMD5(classAsString));
        LOG.trace("Class as string:" + System.lineSeparator() + "'" + classAsString + "'");
        LOG.trace("Class hashcode: '" + this.classSignature.getHash() + "'");
    }

    private void setMethodHash(MethodHashVisitor mhv, String ctorAsString) {
        MethodSignature mSig = mhv.getMethodSignature();
        String stringForHashing = this.hashingUtils.buildHashString(mhv.getTextifier());
        if (mSig.isConstructor()) {
            stringForHashing = ctorAsString + stringForHashing;
        }
        mSig.setHash(this.hashingUtils.toMD5(stringForHashing));
        MethodHashingStringNotifier.notifyCockpitWithHashingString(mSig, stringForHashing);
        LOG.trace("Adding method - name:'{}', hashcode:'{}'", (Object)mSig.getName(), (Object)mSig.getHash());
        LOG.trace("Method hash string:" + System.lineSeparator() + "'" + stringForHashing + "'");
    }

    private void initClassMetadata() {
        if (!this.annotationsCollected) {
            this.collectAnnotations();
            this.annotationsCollected = true;
            this.kotlinMetadata = KotlinMetadataExtractor.extractMetadata(this.classSignature.getClassName(), this.getKotlinAnnotationInfo());
            this.initInternalMethodsFilter();
            this.methodExcludeFilter = new MethodSignatureExcludeFilter(this.classSignature.getSourceLanguage(), this.signatureConfiguration, this.customExcludeMethodFilter, this.kotlinMetadata);
        }
    }

    private void collectAnnotations() {
        for (AnnotationInfoNode node : this.annotationNodes) {
            this.classSignature.getAnnotations().add(node.getAnnotationInfo());
        }
    }

    private void initInternalMethodsFilter() {
        this.internalMethodExcludeFilter = this.isKotlinClass() ? new SkipMethodVisitFilters.KotlinSkipMethodVisitFilter(this.kotlinMetadata) : (this.aspectJAttributesPresent ? new SkipMethodVisitFilters.AspectJSkipMethodFilter() : new SkipMethodVisitFilters.DefaultSkipMethodVisitFilter());
    }

    private void handleAspectJAttributes(Attribute attr) {
        if (attr.type.contains(ASPECTJ_PACKAGE_PREFIX)) {
            this.aspectJAttributesPresent = true;
        }
    }

    private AnnotationInfo getKotlinAnnotationInfo() {
        for (AnnotationInfo annotationInfo : this.classSignature.getAnnotations()) {
            if (!"kotlin.Metadata".equals(annotationInfo.getClassName())) continue;
            return annotationInfo;
        }
        return null;
    }

    private boolean isKotlinClass() {
        return SourceLanguage.KOTLIN == this.classSignature.getSourceLanguage();
    }

    @Generated
    public ClassSignature getClassSignature() {
        return this.classSignature;
    }

    @Generated
    public HashMap<String, MethodHashVisitor> getMethodVisitors() {
        return this.methodVisitors;
    }
}

