/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.commons.instrument.utils.LocalVarSignatureNormalizer;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.util.Textifier;

public class SeaLightsTextifier
extends Textifier {
    private static final String PLAY_ENHANCER_PATTERN = ", line ";
    private ClassSignatureFactory.SignatureConfiguration.SignatureType signatureType;

    public SeaLightsTextifier(ClassSignatureFactory.SignatureConfiguration.SignatureType signatureType) {
        this(589824);
        this.signatureType = signatureType;
    }

    protected SeaLightsTextifier(int api) {
        super(api);
    }

    @Override
    public Textifier visitAnnotationDefault() {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitAnnotationDefault();
    }

    @Override
    public Textifier visitAnnotation(String name, String desc) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitAnnotation(name, desc);
    }

    @Override
    public Textifier visitMethodAnnotation(String desc, boolean visible) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitMethodAnnotation(desc, visible);
    }

    @Override
    public Textifier visitField(int access, String name, String desc, String signature, Object value) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public Textifier visitClassAnnotation(String desc, boolean visible) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitClassAnnotation(desc, visible);
    }

    @Override
    public Textifier visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitParameterAnnotation(parameter, desc, visible);
    }

    @Override
    public Textifier visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitLocalVariable(String className, String methodName, String methodDesc, String name, String descriptor, String signature, Label start, Label end, int index) {
        if (this.isCodeCoverage()) {
            return;
        }
        try {
            String normalizedSignature = new LocalVarSignatureNormalizer(className, methodName, methodDesc, descriptor, signature).normalize();
            this.visitLocalVariable(name, descriptor, normalizedSignature, start, end, index);
        }
        catch (Exception e) {
            AgentLifeCycle.notifyExceptionWarning(this.getClass(), String.format("Failed to visit local var for class:{}, method:{}, descriptor:{}, signature:{}", className, methodDesc, descriptor, signature), e);
        }
    }

    @Override
    public void visitLdcInsn(Object value) {
        String casted;
        int enhanced_index;
        if (this.isCodeCoverage()) {
            return;
        }
        if (value instanceof String && (enhanced_index = (casted = (String)value).indexOf(PLAY_ENHANCER_PATTERN)) != -1) {
            value = casted.substring(0, enhanced_index);
        }
        super.visitLdcInsn(value);
    }

    @Override
    public Textifier visitArray(String name) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitArray(name);
    }

    @Override
    public Textifier visitFieldAnnotation(String desc, boolean visible) {
        if (this.isCodeCoverage()) {
            return this;
        }
        return super.visitFieldAnnotation(desc, visible);
    }

    @Override
    protected void appendHandle(Handle h2) {
        if (this.isLambda(h2.getName())) {
            String modifiedLambdaName = this.modifyLambdaName(h2.getName());
            h2 = new Handle(h2.getTag(), h2.getOwner(), modifiedLambdaName, h2.getDesc(), h2.isInterface());
        }
        super.appendHandle(h2);
    }

    private boolean isLambda(String name) {
        return name != null && name.startsWith("lambda$");
    }

    private String modifyLambdaName(String lambdaName) {
        String[] lambdaNameArray = lambdaName.split("\\$");
        StringBuilder modifiedName = new StringBuilder();
        for (int i = 0; i < lambdaNameArray.length - 1; ++i) {
            modifiedName.append(lambdaNameArray[i]);
            modifiedName.append("$");
        }
        return modifiedName.toString();
    }

    private boolean isCodeCoverage() {
        return this.signatureType == ClassSignatureFactory.SignatureConfiguration.SignatureType.codeCoverage;
    }
}

