/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.GroovyNamingHelper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.instrumentation.MethodNamingUtils;
import java.util.ArrayList;
import java.util.regex.Pattern;
import lombok.Generated;
import org.objectweb.asm.Type;
import org.slf4j.Logger;

public final class MethodNamingHelper {
    private static Logger logger = LogFactory.getLogger(MethodNamingHelper.class);
    public static final String CTOR_INIT = "<init>";
    public static final String CTOR_CLINIT = "<clinit>";

    public static String buildNameForCodeCoverage(MethodSignature methodSignature) {
        logger.trace("##########################################################################");
        String methodName = methodSignature.getName();
        logger.trace("methodName before rename:" + methodName);
        if (MethodNamingHelper.isLambdaExpression(methodSignature.getName())) {
            methodName = MethodNamingHelper.renameLambdaExpression(methodSignature);
        } else {
            String modifiers = MethodNamingUtils.accessToString(methodSignature.getAccess());
            methodName = modifiers + MethodNamingHelper.internalNametoMethodSignature(methodName, methodSignature, true);
            methodName = methodName.replaceAll("transient ", "varargs ");
        }
        logger.trace("methodSignature.getAccess():" + methodSignature.getAccess());
        logger.trace("methodSignature.getClassName():" + methodSignature.getClassName());
        logger.trace("methodSignature.getDescriptor():" + methodSignature.getDescriptor());
        logger.trace("methodSignature.getName():" + methodSignature.getName());
        logger.trace("methodSignature.getLineNumber():" + methodSignature.getEndLineNumber());
        logger.trace("methodName after rename:" + methodName);
        logger.trace("##########################################################################");
        methodName = methodName.replace('$', '.');
        return methodName;
    }

    public static String buildDisplayNameForBuildMapping(MethodSignature methodSignature) {
        String access = MethodNamingUtils.accessToString(methodSignature.getAccess());
        String descriptor = methodSignature.getDescriptor();
        String returnType = MethodNamingHelper.returnTypeToString(descriptor);
        String name = methodSignature.getName();
        String argsType = MethodNamingHelper.getArgumentTypes(descriptor);
        if (MethodNamingHelper.isLambdaExpression(methodSignature.getName())) {
            return "lambda expression: " + returnType + " lambda(" + argsType + ")";
        }
        if (methodSignature.getClassification().isGroovyClosure()) {
            return GroovyNamingHelper.renameClosureExpression(methodSignature, argsType);
        }
        if (MethodNamingHelper.isCtor(methodSignature.getName())) {
            name = MethodNamingHelper.extractClassName(methodSignature.getClassName());
            return access + name + "(" + argsType + ")";
        }
        if (MethodNamingHelper.isStaticCtor(methodSignature.getName())) {
            name = MethodNamingHelper.extractClassName(methodSignature.getClassName());
            return access + name + "(" + argsType + ")";
        }
        return access + returnType + " " + name + "(" + argsType + ")";
    }

    private static String renameLambdaExpression(MethodSignature methodSignature) {
        String escapedString = Pattern.quote("$");
        String originalName = methodSignature.getName();
        String[] tokens = originalName.split(escapedString);
        if (tokens.length != 3) {
            return originalName;
        }
        String methodContainer = tokens[1];
        String lambdaSignature = MethodNamingHelper.internalNametoMethodSignature("lambda", methodSignature, false);
        String modifiedName = "lambda expression (" + lambdaSignature + ") in class " + MethodNamingHelper.toPrintableValue(methodSignature.getClassName());
        if (!"new".equals(methodContainer) && !"null".equals(methodContainer)) {
            modifiedName = "static".equals(methodContainer) ? "static " + modifiedName : "lambda expression (" + lambdaSignature + ") in " + MethodNamingHelper.toPrintableValue(methodContainer) + " method, in class " + MethodNamingHelper.toPrintableValue(methodSignature.getClassName()) + "";
        }
        return modifiedName;
    }

    private static String internalNametoMethodSignature(String internalName, MethodSignature methodSignature, boolean isFullName) {
        StringBuilder methodNameBuilder = new StringBuilder();
        if (MethodNamingHelper.isCtorOrStaticCtor(methodSignature.getName())) {
            methodNameBuilder.append(methodSignature.getClassName());
        } else {
            Type returnType = Type.getReturnType(methodSignature.getDescriptor());
            methodNameBuilder.append(returnType.getClassName());
            methodNameBuilder.append(" ");
            if (isFullName) {
                methodNameBuilder.append(methodSignature.getClassName());
                methodNameBuilder.append(".");
            }
            methodNameBuilder.append(internalName);
        }
        methodNameBuilder.append("(");
        if (methodSignature.getDescriptor() != null) {
            MethodNamingHelper.appendMethodParameters(methodSignature, methodNameBuilder);
        }
        methodNameBuilder.append(")");
        return methodNameBuilder.toString();
    }

    public static String returnTypeToString(String descriptor) {
        Type returnType = Type.getReturnType(descriptor);
        String className = returnType.getClassName();
        String type = MethodNamingHelper.extractClassName(className);
        return type;
    }

    public static String extractClassName(String className) {
        String shortName;
        if (className.contains(".")) {
            String[] splited = className.split("\\.");
            shortName = splited[splited.length - 1];
        } else {
            shortName = className;
        }
        return shortName;
    }

    public static String getArgumentTypes(String descriptor) {
        ArrayList<String> argClasses = new ArrayList<String>();
        for (Type argType : Type.getArgumentTypes(descriptor)) {
            argClasses.add(MethodNamingHelper.extractClassName(argType.getClassName()));
        }
        return StringUtils.join(argClasses, ", ");
    }

    public static void appendMethodParameters(MethodSignature methodSignature, StringBuilder methodNameBuilder) {
        Type[] argumentTypes = Type.getArgumentTypes(methodSignature.getDescriptor());
        String sepeartor = ", ";
        StringBuilder paramsBuilder = new StringBuilder();
        for (Type t : argumentTypes) {
            paramsBuilder.append(t.getClassName());
            paramsBuilder.append(", ");
        }
        String params = paramsBuilder.toString();
        if (params.length() > 0) {
            params = params.substring(0, params.lastIndexOf(", "));
        }
        methodNameBuilder.append(params);
    }

    public static boolean isLambdaExpression(String methodName) {
        return methodName.startsWith("lambda$");
    }

    public static boolean isCtor(String methodName) {
        return CTOR_INIT.equals(methodName);
    }

    public static boolean isStaticCtor(String methodName) {
        return CTOR_CLINIT.equals(methodName);
    }

    public static boolean isCtorOrStaticCtor(String methodName) {
        return MethodNamingHelper.isCtor(methodName) || MethodNamingHelper.isStaticCtor(methodName);
    }

    public static String removeLambdaIndex(String name) {
        int indexOfDollarSign = name.lastIndexOf("$");
        if (indexOfDollarSign < 0) {
            return name;
        }
        return name.substring(0, indexOfDollarSign);
    }

    private static String toPrintableValue(String object) {
        if (object == null) {
            return "<null>";
        }
        return "'" + object + "'";
    }

    @Generated
    private MethodNamingHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

