/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.infra.filters.WildcardPattern;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MethodMatcher {
    private Map<String, List<WildcardPattern>> filterMap;

    public MethodMatcher(String filter) {
        if (StringUtils.isNotEmpty(filter)) {
            String[] methodFullNames;
            this.filterMap = new HashMap<String, List<WildcardPattern>>();
            for (String methodFullName : methodFullNames = filter.split(",")) {
                Map.Entry<String, WildcardPattern> entry = this.parseFilterEntry(methodFullName);
                List<WildcardPattern> wildcardPatterns = this.getWildcardPatternsForClass(entry.getKey());
                wildcardPatterns.add(entry.getValue());
                this.filterMap.put(entry.getKey(), wildcardPatterns);
            }
        }
    }

    private List<WildcardPattern> getWildcardPatternsForClass(String clazz) {
        List<WildcardPattern> wildcardPatterns = this.filterMap.get(clazz);
        if (wildcardPatterns == null) {
            wildcardPatterns = new ArrayList<WildcardPattern>();
        }
        return wildcardPatterns;
    }

    public Map.Entry<String, WildcardPattern> parseFilterEntry(String filterEntry) {
        int methodIndex = filterEntry.lastIndexOf(".");
        if (methodIndex == -1) {
            return new AbstractMap.SimpleEntry<String, WildcardPattern>(filterEntry, new WildcardPattern("*"));
        }
        String className = filterEntry.substring(0, methodIndex);
        WildcardPattern wildcardPattern = new WildcardPattern(filterEntry.substring(methodIndex + 1));
        return new AbstractMap.SimpleEntry<String, WildcardPattern>(className, wildcardPattern);
    }

    public boolean matches(String className, String methodName) {
        if (this.filterMap == null) {
            return false;
        }
        List<WildcardPattern> wildcardPatterns = this.filterMap.get(className);
        if (wildcardPatterns == null) {
            return false;
        }
        for (WildcardPattern wp : wildcardPatterns) {
            if (!wp.matches(methodName)) continue;
            return true;
        }
        return false;
    }
}

