/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodMatcher;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import lombok.Generated;

public class MethodHashingStringNotifier {
    private static final MethodHashingStringNotifier instance = new MethodHashingStringNotifier();
    private final MethodHashingStringNotifierConfiguration config = new MethodHashingStringNotifierConfiguration();
    private MethodMatcher methodMatcher;

    private MethodHashingStringNotifier() {
        this.config.setMethodFilter(System.getProperty("sl.debug.methodFilterForCockpitNotification"));
        this.configure();
    }

    public static void notifyCockpitWithHashingString(MethodSignature ms, String stringForHashing) {
        boolean needToSend = MethodHashingStringNotifier.instance.methodMatcher.matches(ms.getClassName(), ms.getName());
        if (needToSend) {
            String message = String.format("class name: %s, method name: %s, method hash: %s, method body: %s", ms.getClassName(), ms.getName(), ms.getHash(), stringForHashing);
            AgentLifeCycle.notifySuperUserMsg(AgentEventsController.NotifMsgLevel.INFO, message);
        }
    }

    public static void onConfigurationChanged() {
        instance.configure();
    }

    public static MethodHashingStringNotifierConfiguration getConfig() {
        return MethodHashingStringNotifier.instance.config;
    }

    public static MethodMatcher getMethodMatcher() {
        return MethodHashingStringNotifier.instance.methodMatcher;
    }

    private void configure() {
        this.methodMatcher = new MethodMatcher(this.config.getMethodFilter());
    }

    public static class MethodHashingStringNotifierConfiguration {
        private String methodFilter;

        @Generated
        public MethodHashingStringNotifierConfiguration() {
        }

        @Generated
        public String getMethodFilter() {
            return this.methodFilter;
        }

        @Generated
        public void setMethodFilter(String methodFilter) {
            this.methodFilter = methodFilter;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodHashingStringNotifierConfiguration)) {
                return false;
            }
            MethodHashingStringNotifierConfiguration other = (MethodHashingStringNotifierConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$methodFilter = this.getMethodFilter();
            String other$methodFilter = other.getMethodFilter();
            return !(this$methodFilter == null ? other$methodFilter != null : !this$methodFilter.equals(other$methodFilter));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MethodHashingStringNotifierConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $methodFilter = this.getMethodFilter();
            result = result * 59 + ($methodFilter == null ? 43 : $methodFilter.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MethodHashingStringNotifier.MethodHashingStringNotifierConfiguration(methodFilter=" + this.getMethodFilter() + ")";
        }
    }
}

