/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;

public class LocalVarSignatureNormalizer {
    private static final Logger LOG = LogFactory.getLogger(LocalVarSignatureNormalizer.class);
    protected static final String INVALID_LAMBDA_ARG_PATTERN = "!*";
    protected static final String INVALID_LAMBDA_GENERIC_ARG_PATTERN_1 = "++";
    protected static final String LAMBDA_GENERIC_ARG_PATTERN_FIX_1 = "+";
    protected static final String INVALID_LAMBDA_GENERIC_ARG_PATTERN_2 = "<+*>";
    protected static final String LAMBDA_GENERIC_ARG_PATTERN_FIX_2 = "";
    private String className;
    private String methodName;
    private String methodDesc;
    private String descriptor;
    private String signature;

    public String normalize() {
        if (this.signature == null) {
            return null;
        }
        String modifiedSignature = this.signature;
        if (modifiedSignature.equals(INVALID_LAMBDA_ARG_PATTERN)) {
            modifiedSignature = null;
            this.logInvalidLocalVarSignature(modifiedSignature, INVALID_LAMBDA_ARG_PATTERN);
        } else if (modifiedSignature.contains(INVALID_LAMBDA_GENERIC_ARG_PATTERN_1)) {
            modifiedSignature = modifiedSignature.replace(INVALID_LAMBDA_GENERIC_ARG_PATTERN_1, LAMBDA_GENERIC_ARG_PATTERN_FIX_1);
            this.logInvalidLocalVarSignature(modifiedSignature, INVALID_LAMBDA_GENERIC_ARG_PATTERN_1);
        } else if (modifiedSignature.contains(INVALID_LAMBDA_GENERIC_ARG_PATTERN_2)) {
            modifiedSignature = modifiedSignature.replace(INVALID_LAMBDA_GENERIC_ARG_PATTERN_2, LAMBDA_GENERIC_ARG_PATTERN_FIX_2);
            this.logInvalidLocalVarSignature(modifiedSignature, INVALID_LAMBDA_GENERIC_ARG_PATTERN_2);
        }
        return modifiedSignature;
    }

    private void logInvalidLocalVarSignature(String modifiedSignature, String invalidPattern) {
        LOG.warn("illegal pattern '{}' was detected in local var signature'{}' --> the signature was changed to:'{}'. More details: class:'{}', method:'{}', method desc:'{}', var descriptor:'{}'", invalidPattern, this.signature, modifiedSignature, this.className, this.methodName, this.methodDesc, this.descriptor);
    }

    @ConstructorProperties(value={"className", "methodName", "methodDesc", "descriptor", "signature"})
    @Generated
    public LocalVarSignatureNormalizer(String className, String methodName, String methodDesc, String descriptor, String signature) {
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        this.descriptor = descriptor;
        this.signature = signature;
    }
}

