/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.regex.Pattern;
import org.objectweb.asm.util.Printer;

public class HashingUtils {
    private static final String CLASS_VERSION = "// class version";
    private static final String NEW_LINE = "\n";
    private static final Pattern ASM_LABEL_PATTERN = Pattern.compile("^\\s*L[0-9]*$");
    private static final Pattern ASPECT_J_CLASS_PATTERN = Pattern.compile(".*\\$AjcClosure[0-9].*");

    public String sanitizeHashedString(String asmTextifierOutput) {
        if (asmTextifierOutput == null) {
            return asmTextifierOutput;
        }
        String[] lines = asmTextifierOutput.split("\\n");
        if (lines.length == 0) {
            return asmTextifierOutput;
        }
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if (line.toLowerCase().contains(CLASS_VERSION)) continue;
            if (ASM_LABEL_PATTERN.matcher(line).matches()) {
                line = this.removeNumbersFromEndOfString(line, "L");
            } else if (ASPECT_J_CLASS_PATTERN.matcher(line).matches()) {
                line = this.removeNumbersFromEndOfString(line, "$AjcClosure");
            }
            sb.append(line);
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public String toMD5(String data2) {
        if (data2 == null) {
            throw new NullPointerException("Cannot convert to MD5: data cannot be null");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] bytesOfMessage = data2.getBytes("UTF-8");
            byte[] theDigest = md.digest(bytesOfMessage);
            BigInteger bigInt = new BigInteger(1, theDigest);
            String hashtext = bigInt.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed convert to MD5", e);
        }
    }

    public String buildHashString(Printer printer) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        printer.print(pw);
        String printerAsString = sw.toString();
        printerAsString = this.sanitizeHashedString(printerAsString);
        return printerAsString;
    }

    private String removeNumbersFromEndOfString(String line, String end) {
        return line.substring(0, line.indexOf(end) + end.length());
    }
}

