/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import java.util.regex.Pattern;

public class GroovyNamingHelper {
    private static final String CLOSURE_CLASS_NAME = "_closure";
    private static final String CLOSURE_CLASS_WITH_INDEX = "_closure\\d+";
    public static final String CLASS_DELIMITER = Pattern.quote("$_");
    private static final String CONTAINER_DELIMITER = Pattern.quote("_");
    private static final String GLOBAL_CLOSURE = "Global closure";
    private static final String NESTED_CLOSURE_PREFIX = "#closure";
    private static final String CLOSURE_SIGNATURE_FORMAT = " (%s)";

    public static String renameClosureExpression(MethodSignature methodSignature, String argumentTypes) {
        String originalClassName = methodSignature.getClassName();
        String[] tokens = originalClassName.split(CLASS_DELIMITER);
        if (tokens.length == 1) {
            return methodSignature.getName();
        }
        String[] containerTokens = tokens[1].split(CONTAINER_DELIMITER);
        if (containerTokens.length == 1) {
            return GroovyNamingHelper.formatClosureDisplayName(GLOBAL_CLOSURE, argumentTypes);
        }
        return GroovyNamingHelper.formatClosureDisplayName(containerTokens[0] + NESTED_CLOSURE_PREFIX, argumentTypes);
    }

    public static String removeClosureIndex(String name) {
        return name.replaceAll(CLOSURE_CLASS_WITH_INDEX, CLOSURE_CLASS_NAME);
    }

    private static String formatClosureDisplayName(String name, String argumentTypes) {
        return String.format(name + CLOSURE_SIGNATURE_FORMAT, argumentTypes);
    }
}

