/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.commons.instrument.utils.ClassDumper;
import io.sealights.onpremise.agents.commons.utils.ZipUtils;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.http.api.BlobsServiceProxyHandler;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;

public class DebugClassDumper {
    private static DebugClassDumper instance;
    private static final Logger LOG;
    public static final String BYTE_CODE_DUMP_BLOB_TYPE = "byteCodeDump";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'HH-mm-ss";
    public String baseDumpsDir;
    private final String printBeforeAndAfterByteCodeClassFilter;
    private final String[] filterList;
    private String dumpPrefix = DebugClassDumper.getDumpPrefix();
    private Path beforeInstrumentationDumpDir;
    private Path afterInstrumentationDumpDir;
    private Path beforeInstrumentationDumpZip;
    private Path afterInstrumentationDumpZip;
    private boolean enabled;

    private DebugClassDumper() {
        String tmpDir = SystemPropertiesHelper.getStrProperty("java.io.tmpdir", "/tmp");
        this.baseDumpsDir = tmpDir + "/sl/class-dumps";
        this.beforeInstrumentationDumpDir = Paths.get(this.baseDumpsDir, this.dumpPrefix, this.dumpPrefix + "-before");
        this.afterInstrumentationDumpDir = Paths.get(this.baseDumpsDir, this.dumpPrefix, this.dumpPrefix + "-after");
        this.beforeInstrumentationDumpZip = Paths.get(this.baseDumpsDir, this.dumpPrefix, this.dumpPrefix + "-before.zip");
        this.afterInstrumentationDumpZip = Paths.get(this.baseDumpsDir, this.dumpPrefix, this.dumpPrefix + "-after.zip");
        this.printBeforeAndAfterByteCodeClassFilter = System.getProperty("sl.debug.printBeforeAfterByteCodeClassFilter");
        if (this.printBeforeAndAfterByteCodeClassFilter == null || this.printBeforeAndAfterByteCodeClassFilter.isEmpty()) {
            LOG.info("debugClassDumper is disabled");
            this.filterList = new String[0];
            this.enabled = false;
        } else {
            this.enabled = true;
            this.filterList = this.printBeforeAndAfterByteCodeClassFilter.split(",");
        }
    }

    public static synchronized DebugClassDumper getInstance() {
        if (instance == null) {
            instance = new DebugClassDumper();
        }
        return instance;
    }

    public byte[] printDumpAndReturn(String className, byte[] classBytes, byte[] transformedClassBytes) {
        if (!this.enabled) {
            return transformedClassBytes;
        }
        String dotClassName = className.replace('/', '.');
        for (String filterLine : this.filterList) {
            if (!dotClassName.equalsIgnoreCase(filterLine) && !dotClassName.matches(filterLine)) continue;
            this.writeDebugByteCode(className, classBytes, transformedClassBytes, dotClassName);
            break;
        }
        return transformedClassBytes;
    }

    void writeDebugByteCode(String className, byte[] classBytes, byte[] transformedClassBytes, String dotClassName) {
        LOG.debug("before transformation");
        ClassDumper.dumpClass(className, classBytes);
        this.writeDebugBeteCodeToFile(this.beforeInstrumentationDumpDir, dotClassName, classBytes);
        LOG.debug("after transformation");
        ClassDumper.dumpClass(className, transformedClassBytes);
        this.writeDebugBeteCodeToFile(this.afterInstrumentationDumpDir, dotClassName, transformedClassBytes);
    }

    void writeDebugBeteCodeToFile(Path dumpDir, String dotClassName, byte[] classBytes) {
        Path filePath = dumpDir.resolve(dotClassName + ".class");
        try {
            Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
            FileUtils.writeByteArrayToFile(filePath.toFile(), classBytes, false);
        }
        catch (IOException e) {
            LOG.warn("", e);
        }
    }

    public static void sendBlobsOnShutDown(String buildSessionId, String token, String server, String proxy) {
        boolean sendClassDumpsOnShutdown = SystemPropertiesHelper.getBoolProperty("sl.debug.sendClassDumpsOnShutdown");
        if (!sendClassDumpsOnShutdown) {
            return;
        }
        DebugClassDumper debugClassDumper = DebugClassDumper.getInstance();
        if (!debugClassDumper.enabled) {
            return;
        }
        LOG.info("send before and after instrumentation byte code dumps");
        BlobsServiceProxyHandler blobsServiceProxyHandler = new BlobsServiceProxyHandler(token, server, proxy);
        debugClassDumper.createZipArchives();
        blobsServiceProxyHandler.sendBlobData(buildSessionId, BYTE_CODE_DUMP_BLOB_TYPE, debugClassDumper.beforeInstrumentationDumpZip);
        blobsServiceProxyHandler.sendBlobData(buildSessionId, BYTE_CODE_DUMP_BLOB_TYPE, debugClassDumper.afterInstrumentationDumpZip);
    }

    private void createZipArchives() {
        try {
            ZipUtils.pack(this.beforeInstrumentationDumpDir, this.beforeInstrumentationDumpZip);
            ZipUtils.pack(this.afterInstrumentationDumpDir, this.afterInstrumentationDumpZip);
        }
        catch (IOException e) {
            LOG.warn("", e);
        }
    }

    public static String getDumpPrefix() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    static {
        LOG = LogFactory.getLogger(DebugClassDumper.class);
    }
}

