/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.HashingUtils;
import io.sealights.onpremise.agents.commons.instrument.visitors.ClassHashVisitor;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureExcludeFilter;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import lombok.Generated;
import org.objectweb.asm.ClassReader;

public final class ClassSignatureFactory {
    public static ClassSignature createDefaultScanSignature(InputStream inputStream) {
        return ClassSignatureFactory.createSignature(inputStream, SignatureConfiguration.createScanConfig(), null);
    }

    public static ClassSignature createCoverageSignature(InputStream inputStream, boolean withLineCoverage, boolean ignoreAutoGeneratedMethods) {
        return ClassSignatureFactory.createSignature(inputStream, SignatureConfiguration.createCoverageConfig(withLineCoverage, ignoreAutoGeneratedMethods), null);
    }

    public static ClassSignature createSignature(InputStream inputStream, SignatureConfiguration configuration, MethodSignatureExcludeFilter.CustomExcludeMethodFilter customExcludeMethodFilter) {
        ClassHashVisitor classMapper = new ClassHashVisitor(configuration, customExcludeMethodFilter, new HashingUtils());
        try {
            ClassReader cr = new ClassReader(inputStream);
            cr.accept(classMapper, 4);
            return classMapper.getClassSignature();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static SignatureConfiguration createSignatureConfiguration(SignatureConfiguration.SignatureType signatureType, boolean withLineCoverage, boolean ignoreAutoGeneratedMethods) {
        return SignatureConfiguration.builder().type(signatureType).withLineCoverage(withLineCoverage).ignoreAutoGeneratedCode(ignoreAutoGeneratedMethods).withConstructors(true).withGettersSetters(true).ignoreMethodsWithoutLineNumbers(false).build();
    }

    @Generated
    private ClassSignatureFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static class SignatureConfiguration {
        private final SignatureType type;
        private boolean withLineCoverage = false;
        private boolean ignoreAutoGeneratedCode = false;
        private boolean withConstructors = false;
        private boolean withGettersSetters = false;
        private boolean ignoreMethodsWithoutLineNumbers = false;
        private String classAnnotationsExcluded;
        private String methodAnnotationsExcluded;

        private SignatureConfiguration(SignatureType type) {
            this.type = type;
        }

        public static SignatureConfiguration createCoverageConfig() {
            return new SignatureConfiguration(SignatureType.codeCoverage);
        }

        public static SignatureConfiguration createCoverageConfig(boolean withLineCoverage, boolean ignoreAutoGeneratedMethods) {
            return ClassSignatureFactory.createSignatureConfiguration(SignatureType.codeCoverage, withLineCoverage, ignoreAutoGeneratedMethods);
        }

        public static SignatureConfiguration createScanConfig() {
            return new SignatureConfiguration(SignatureType.codeScan);
        }

        public static SignatureConfiguration createScanConfig(boolean withLineCoverage, boolean ignoreAutoGeneratedMethods) {
            return ClassSignatureFactory.createSignatureConfiguration(SignatureType.codeScan, withLineCoverage, ignoreAutoGeneratedMethods);
        }

        public boolean isScanSignature() {
            return this.type == SignatureType.codeScan;
        }

        @Generated
        public static SignatureConfigurationBuilder builder() {
            return new SignatureConfigurationBuilder();
        }

        @Generated
        public SignatureType getType() {
            return this.type;
        }

        @Generated
        public boolean isWithLineCoverage() {
            return this.withLineCoverage;
        }

        @Generated
        public boolean isIgnoreAutoGeneratedCode() {
            return this.ignoreAutoGeneratedCode;
        }

        @Generated
        public boolean isWithConstructors() {
            return this.withConstructors;
        }

        @Generated
        public boolean isWithGettersSetters() {
            return this.withGettersSetters;
        }

        @Generated
        public boolean isIgnoreMethodsWithoutLineNumbers() {
            return this.ignoreMethodsWithoutLineNumbers;
        }

        @Generated
        public String getClassAnnotationsExcluded() {
            return this.classAnnotationsExcluded;
        }

        @Generated
        public String getMethodAnnotationsExcluded() {
            return this.methodAnnotationsExcluded;
        }

        @Generated
        public void setWithLineCoverage(boolean withLineCoverage) {
            this.withLineCoverage = withLineCoverage;
        }

        @Generated
        public void setIgnoreAutoGeneratedCode(boolean ignoreAutoGeneratedCode) {
            this.ignoreAutoGeneratedCode = ignoreAutoGeneratedCode;
        }

        @Generated
        public void setWithConstructors(boolean withConstructors) {
            this.withConstructors = withConstructors;
        }

        @Generated
        public void setWithGettersSetters(boolean withGettersSetters) {
            this.withGettersSetters = withGettersSetters;
        }

        @Generated
        public void setIgnoreMethodsWithoutLineNumbers(boolean ignoreMethodsWithoutLineNumbers) {
            this.ignoreMethodsWithoutLineNumbers = ignoreMethodsWithoutLineNumbers;
        }

        @Generated
        public void setClassAnnotationsExcluded(String classAnnotationsExcluded) {
            this.classAnnotationsExcluded = classAnnotationsExcluded;
        }

        @Generated
        public void setMethodAnnotationsExcluded(String methodAnnotationsExcluded) {
            this.methodAnnotationsExcluded = methodAnnotationsExcluded;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureConfiguration)) {
                return false;
            }
            SignatureConfiguration other = (SignatureConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SignatureType this$type = this.getType();
            SignatureType other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            if (this.isWithLineCoverage() != other.isWithLineCoverage()) {
                return false;
            }
            if (this.isIgnoreAutoGeneratedCode() != other.isIgnoreAutoGeneratedCode()) {
                return false;
            }
            if (this.isWithConstructors() != other.isWithConstructors()) {
                return false;
            }
            if (this.isWithGettersSetters() != other.isWithGettersSetters()) {
                return false;
            }
            if (this.isIgnoreMethodsWithoutLineNumbers() != other.isIgnoreMethodsWithoutLineNumbers()) {
                return false;
            }
            String this$classAnnotationsExcluded = this.getClassAnnotationsExcluded();
            String other$classAnnotationsExcluded = other.getClassAnnotationsExcluded();
            if (this$classAnnotationsExcluded == null ? other$classAnnotationsExcluded != null : !this$classAnnotationsExcluded.equals(other$classAnnotationsExcluded)) {
                return false;
            }
            String this$methodAnnotationsExcluded = this.getMethodAnnotationsExcluded();
            String other$methodAnnotationsExcluded = other.getMethodAnnotationsExcluded();
            return !(this$methodAnnotationsExcluded == null ? other$methodAnnotationsExcluded != null : !this$methodAnnotationsExcluded.equals(other$methodAnnotationsExcluded));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SignatureConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SignatureType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            result = result * 59 + (this.isWithLineCoverage() ? 79 : 97);
            result = result * 59 + (this.isIgnoreAutoGeneratedCode() ? 79 : 97);
            result = result * 59 + (this.isWithConstructors() ? 79 : 97);
            result = result * 59 + (this.isWithGettersSetters() ? 79 : 97);
            result = result * 59 + (this.isIgnoreMethodsWithoutLineNumbers() ? 79 : 97);
            String $classAnnotationsExcluded = this.getClassAnnotationsExcluded();
            result = result * 59 + ($classAnnotationsExcluded == null ? 43 : $classAnnotationsExcluded.hashCode());
            String $methodAnnotationsExcluded = this.getMethodAnnotationsExcluded();
            result = result * 59 + ($methodAnnotationsExcluded == null ? 43 : $methodAnnotationsExcluded.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ClassSignatureFactory.SignatureConfiguration(type=" + (Object)((Object)this.getType()) + ", withLineCoverage=" + this.isWithLineCoverage() + ", ignoreAutoGeneratedCode=" + this.isIgnoreAutoGeneratedCode() + ", withConstructors=" + this.isWithConstructors() + ", withGettersSetters=" + this.isWithGettersSetters() + ", ignoreMethodsWithoutLineNumbers=" + this.isIgnoreMethodsWithoutLineNumbers() + ", classAnnotationsExcluded=" + this.getClassAnnotationsExcluded() + ", methodAnnotationsExcluded=" + this.getMethodAnnotationsExcluded() + ")";
        }

        @ConstructorProperties(value={"type", "withLineCoverage", "ignoreAutoGeneratedCode", "withConstructors", "withGettersSetters", "ignoreMethodsWithoutLineNumbers", "classAnnotationsExcluded", "methodAnnotationsExcluded"})
        @Generated
        public SignatureConfiguration(SignatureType type, boolean withLineCoverage, boolean ignoreAutoGeneratedCode, boolean withConstructors, boolean withGettersSetters, boolean ignoreMethodsWithoutLineNumbers, String classAnnotationsExcluded, String methodAnnotationsExcluded) {
            this.type = type;
            this.withLineCoverage = withLineCoverage;
            this.ignoreAutoGeneratedCode = ignoreAutoGeneratedCode;
            this.withConstructors = withConstructors;
            this.withGettersSetters = withGettersSetters;
            this.ignoreMethodsWithoutLineNumbers = ignoreMethodsWithoutLineNumbers;
            this.classAnnotationsExcluded = classAnnotationsExcluded;
            this.methodAnnotationsExcluded = methodAnnotationsExcluded;
        }

        @Generated
        public static class SignatureConfigurationBuilder {
            @Generated
            private SignatureType type;
            @Generated
            private boolean withLineCoverage;
            @Generated
            private boolean ignoreAutoGeneratedCode;
            @Generated
            private boolean withConstructors;
            @Generated
            private boolean withGettersSetters;
            @Generated
            private boolean ignoreMethodsWithoutLineNumbers;
            @Generated
            private String classAnnotationsExcluded;
            @Generated
            private String methodAnnotationsExcluded;

            @Generated
            SignatureConfigurationBuilder() {
            }

            @Generated
            public SignatureConfigurationBuilder type(SignatureType type) {
                this.type = type;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder withLineCoverage(boolean withLineCoverage) {
                this.withLineCoverage = withLineCoverage;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder ignoreAutoGeneratedCode(boolean ignoreAutoGeneratedCode) {
                this.ignoreAutoGeneratedCode = ignoreAutoGeneratedCode;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder withConstructors(boolean withConstructors) {
                this.withConstructors = withConstructors;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder withGettersSetters(boolean withGettersSetters) {
                this.withGettersSetters = withGettersSetters;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder ignoreMethodsWithoutLineNumbers(boolean ignoreMethodsWithoutLineNumbers) {
                this.ignoreMethodsWithoutLineNumbers = ignoreMethodsWithoutLineNumbers;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder classAnnotationsExcluded(String classAnnotationsExcluded) {
                this.classAnnotationsExcluded = classAnnotationsExcluded;
                return this;
            }

            @Generated
            public SignatureConfigurationBuilder methodAnnotationsExcluded(String methodAnnotationsExcluded) {
                this.methodAnnotationsExcluded = methodAnnotationsExcluded;
                return this;
            }

            @Generated
            public SignatureConfiguration build() {
                return new SignatureConfiguration(this.type, this.withLineCoverage, this.ignoreAutoGeneratedCode, this.withConstructors, this.withGettersSetters, this.ignoreMethodsWithoutLineNumbers, this.classAnnotationsExcluded, this.methodAnnotationsExcluded);
            }

            @Generated
            public String toString() {
                return "ClassSignatureFactory.SignatureConfiguration.SignatureConfigurationBuilder(type=" + (Object)((Object)this.type) + ", withLineCoverage=" + this.withLineCoverage + ", ignoreAutoGeneratedCode=" + this.ignoreAutoGeneratedCode + ", withConstructors=" + this.withConstructors + ", withGettersSetters=" + this.withGettersSetters + ", ignoreMethodsWithoutLineNumbers=" + this.ignoreMethodsWithoutLineNumbers + ", classAnnotationsExcluded=" + this.classAnnotationsExcluded + ", methodAnnotationsExcluded=" + this.methodAnnotationsExcluded + ")";
            }
        }

        public static enum SignatureType {
            codeScan,
            codeCoverage;

        }
    }
}

