/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.utils;

import lombok.Generated;

public final class ClassNameConverter {
    private static char DOT = (char)46;
    private static char HASHTAG = (char)35;
    private static char SLASH = (char)47;

    public static String hashtagToClassName(String hashTagSeparated) {
        return hashTagSeparated.replace(HASHTAG, DOT);
    }

    public static String hashtagToBinaryName(String hashTagSeparated) {
        return hashTagSeparated.replace(HASHTAG, SLASH);
    }

    public static String classToBinaryName(String className) {
        return className.replace(DOT, SLASH);
    }

    public static String binaryToClassName(String binaryName) {
        return binaryName.replace(SLASH, DOT);
    }

    public static String classBinaryNameToDescriptor(String binaryName) {
        return String.format("L%s;", binaryName);
    }

    public static String classBinNameToMethodInsnDesc(String binaryName) {
        return String.format("()L%s;", binaryName);
    }

    public static boolean isInternalClassName(String className) {
        return className.indexOf(SLASH) != -1;
    }

    @Generated
    private ClassNameConverter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

