/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.types;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Label;

public class Probe
implements Serializable {
    private transient Label startLabel;
    private transient Label endLabel;
    public final boolean backwards;
    public Integer start;
    public Integer end;
    public List<String> hash;

    public Probe(boolean backwards, Label entry, Label target) {
        this.backwards = backwards;
        if (this.backwards) {
            this.startLabel = target;
            this.endLabel = entry;
        } else {
            this.startLabel = entry;
            this.endLabel = target;
        }
    }

    public void resolve(Map<Label, Integer> lines, Map<Label, Integer> hashScope, List<String> hashes) {
        this.start = lines.get(this.startLabel);
        this.end = lines.get(this.endLabel);
        this.hash = new ArrayList<String>(hashes.subList(this.startLabel == null ? 0 : hashScope.get(this.startLabel), this.endLabel == null ? hashes.size() : hashScope.get(this.endLabel).intValue()));
    }

    public String toString() {
        return "Probe:" + this.start + "-" + this.end + " " + this.hash;
    }
}

