/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.commons.instrument.types;

import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodNamingHelper;
import io.sealights.onpremise.agents.commons.instrument.visitors.KotlinMetadataExtractor;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.instrument.filters.AutoGeneratedMethodClassifier;
import io.sealights.onpremise.agents.instrument.filters.KotlinMethodClassifier;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class MethodSignature {
    private int index;
    private String className;
    private String name;
    private String descriptor;
    private int access;
    private String elementId;
    private String hash;
    private Integer endLineNumber;
    private Integer startLineNumber;
    private String uniqueId;
    private MethodClassification classification = new MethodClassification();
    private List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();

    public MethodSignature(String className, String name, String descriptor, int access, String elementId, String uniqueId, int index) {
        this.className = className;
        this.name = name;
        this.descriptor = descriptor;
        this.access = access;
        this.elementId = elementId;
        this.uniqueId = uniqueId;
        this.index = index;
    }

    public Integer getColumnNumber() {
        return null;
    }

    public boolean isGetterOrSetter() {
        return this.classification.isGetterOrSetter();
    }

    public void setGetterOrSetter(boolean getterOrSetter) {
        this.classification.setGetterOrSetter(getterOrSetter);
    }

    public boolean isConstructor() {
        return this.classification.isConstructor();
    }

    public boolean isAnonymous() {
        return this.classification.isAnonymous();
    }

    public boolean isAutoGenerated() {
        return this.classification.isAutoGenerated();
    }

    public void applyVisitLineNumber(int lineNumber) {
        if (this.endLineNumber == null) {
            this.endLineNumber = lineNumber;
        }
        if (this.startLineNumber == null) {
            this.startLineNumber = lineNumber;
        } else if (lineNumber < this.startLineNumber) {
            this.startLineNumber = lineNumber;
        } else if (lineNumber > this.endLineNumber) {
            this.endLineNumber = lineNumber;
        }
    }

    public void calculateClassification(KotlinMetadataExtractor.KotlinMetadata kotlinClassMetadata) {
        this.classification.setConstructor(MethodNamingHelper.isCtorOrStaticCtor(this.name));
        boolean isAnonymous = kotlinClassMetadata == null ? MethodNamingHelper.isLambdaExpression(this.name) : new KotlinMethodClassifier.KotlinInvokeFilter(kotlinClassMetadata).match(this);
        this.classification.setAnonymous(isAnonymous);
        this.classification.setAutoGenerated(new AutoGeneratedMethodClassifier(kotlinClassMetadata).match(this));
    }

    public String toString() {
        return String.format("MethodSignature: %s", JsonObjectMapper.toJson(this));
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescriptor() {
        return this.descriptor;
    }

    @Generated
    public int getAccess() {
        return this.access;
    }

    @Generated
    public String getElementId() {
        return this.elementId;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public Integer getEndLineNumber() {
        return this.endLineNumber;
    }

    @Generated
    public Integer getStartLineNumber() {
        return this.startLineNumber;
    }

    @Generated
    public String getUniqueId() {
        return this.uniqueId;
    }

    @Generated
    public MethodClassification getClassification() {
        return this.classification;
    }

    @Generated
    public List<AnnotationInfo> getAnnotations() {
        return this.annotations;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDescriptor(String descriptor) {
        this.descriptor = descriptor;
    }

    @Generated
    public void setAccess(int access) {
        this.access = access;
    }

    @Generated
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setEndLineNumber(Integer endLineNumber) {
        this.endLineNumber = endLineNumber;
    }

    @Generated
    public void setStartLineNumber(Integer startLineNumber) {
        this.startLineNumber = startLineNumber;
    }

    @Generated
    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Generated
    public void setClassification(MethodClassification classification) {
        this.classification = classification;
    }

    @Generated
    public void setAnnotations(List<AnnotationInfo> annotations) {
        this.annotations = annotations;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature other = (MethodSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$descriptor = this.getDescriptor();
        String other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        if (this.getAccess() != other.getAccess()) {
            return false;
        }
        String this$elementId = this.getElementId();
        String other$elementId = other.getElementId();
        if (this$elementId == null ? other$elementId != null : !this$elementId.equals(other$elementId)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        Integer this$endLineNumber = this.getEndLineNumber();
        Integer other$endLineNumber = other.getEndLineNumber();
        if (this$endLineNumber == null ? other$endLineNumber != null : !((Object)this$endLineNumber).equals(other$endLineNumber)) {
            return false;
        }
        Integer this$startLineNumber = this.getStartLineNumber();
        Integer other$startLineNumber = other.getStartLineNumber();
        if (this$startLineNumber == null ? other$startLineNumber != null : !((Object)this$startLineNumber).equals(other$startLineNumber)) {
            return false;
        }
        String this$uniqueId = this.getUniqueId();
        String other$uniqueId = other.getUniqueId();
        if (this$uniqueId == null ? other$uniqueId != null : !this$uniqueId.equals(other$uniqueId)) {
            return false;
        }
        MethodClassification this$classification = this.getClassification();
        MethodClassification other$classification = other.getClassification();
        if (this$classification == null ? other$classification != null : !((Object)this$classification).equals(other$classification)) {
            return false;
        }
        List<AnnotationInfo> this$annotations = this.getAnnotations();
        List<AnnotationInfo> other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MethodSignature;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
        result = result * 59 + this.getAccess();
        String $elementId = this.getElementId();
        result = result * 59 + ($elementId == null ? 43 : $elementId.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        Integer $endLineNumber = this.getEndLineNumber();
        result = result * 59 + ($endLineNumber == null ? 43 : ((Object)$endLineNumber).hashCode());
        Integer $startLineNumber = this.getStartLineNumber();
        result = result * 59 + ($startLineNumber == null ? 43 : ((Object)$startLineNumber).hashCode());
        String $uniqueId = this.getUniqueId();
        result = result * 59 + ($uniqueId == null ? 43 : $uniqueId.hashCode());
        MethodClassification $classification = this.getClassification();
        result = result * 59 + ($classification == null ? 43 : ((Object)$classification).hashCode());
        List<AnnotationInfo> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        return result;
    }

    @Generated
    public MethodSignature() {
    }

    public static class MethodClassification {
        private boolean constructor = false;
        private boolean anonymous = false;
        private boolean getterOrSetter = false;
        private boolean autoGenerated = false;
        private boolean groovyClosure = false;

        @Generated
        public MethodClassification() {
        }

        @Generated
        public boolean isConstructor() {
            return this.constructor;
        }

        @Generated
        public boolean isAnonymous() {
            return this.anonymous;
        }

        @Generated
        public boolean isGetterOrSetter() {
            return this.getterOrSetter;
        }

        @Generated
        public boolean isAutoGenerated() {
            return this.autoGenerated;
        }

        @Generated
        public boolean isGroovyClosure() {
            return this.groovyClosure;
        }

        @Generated
        public void setConstructor(boolean constructor) {
            this.constructor = constructor;
        }

        @Generated
        public void setAnonymous(boolean anonymous) {
            this.anonymous = anonymous;
        }

        @Generated
        public void setGetterOrSetter(boolean getterOrSetter) {
            this.getterOrSetter = getterOrSetter;
        }

        @Generated
        public void setAutoGenerated(boolean autoGenerated) {
            this.autoGenerated = autoGenerated;
        }

        @Generated
        public void setGroovyClosure(boolean groovyClosure) {
            this.groovyClosure = groovyClosure;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MethodClassification)) {
                return false;
            }
            MethodClassification other = (MethodClassification)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isConstructor() != other.isConstructor()) {
                return false;
            }
            if (this.isAnonymous() != other.isAnonymous()) {
                return false;
            }
            if (this.isGetterOrSetter() != other.isGetterOrSetter()) {
                return false;
            }
            if (this.isAutoGenerated() != other.isAutoGenerated()) {
                return false;
            }
            return this.isGroovyClosure() == other.isGroovyClosure();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MethodClassification;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isConstructor() ? 79 : 97);
            result = result * 59 + (this.isAnonymous() ? 79 : 97);
            result = result * 59 + (this.isGetterOrSetter() ? 79 : 97);
            result = result * 59 + (this.isAutoGenerated() ? 79 : 97);
            result = result * 59 + (this.isGroovyClosure() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "MethodSignature.MethodClassification(constructor=" + this.isConstructor() + ", anonymous=" + this.isAnonymous() + ", getterOrSetter=" + this.isGetterOrSetter() + ", autoGenerated=" + this.isAutoGenerated() + ", groovyClosure=" + this.isGroovyClosure() + ")";
        }
    }
}

